// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in time, the resource will go in Suspended state. </summary>
    public readonly partial struct DynatraceMonitorMarketplaceSubscriptionStatus : IEquatable<DynatraceMonitorMarketplaceSubscriptionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynatraceMonitorMarketplaceSubscriptionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynatraceMonitorMarketplaceSubscriptionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string SuspendedValue = "Suspended";

        /// <summary> Active. </summary>
        public static DynatraceMonitorMarketplaceSubscriptionStatus Active { get; } = new DynatraceMonitorMarketplaceSubscriptionStatus(ActiveValue);
        /// <summary> Suspended. </summary>
        public static DynatraceMonitorMarketplaceSubscriptionStatus Suspended { get; } = new DynatraceMonitorMarketplaceSubscriptionStatus(SuspendedValue);
        /// <summary> Determines if two <see cref="DynatraceMonitorMarketplaceSubscriptionStatus"/> values are the same. </summary>
        public static bool operator ==(DynatraceMonitorMarketplaceSubscriptionStatus left, DynatraceMonitorMarketplaceSubscriptionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynatraceMonitorMarketplaceSubscriptionStatus"/> values are not the same. </summary>
        public static bool operator !=(DynatraceMonitorMarketplaceSubscriptionStatus left, DynatraceMonitorMarketplaceSubscriptionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynatraceMonitorMarketplaceSubscriptionStatus"/>. </summary>
        public static implicit operator DynatraceMonitorMarketplaceSubscriptionStatus(string value) => new DynatraceMonitorMarketplaceSubscriptionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynatraceMonitorMarketplaceSubscriptionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynatraceMonitorMarketplaceSubscriptionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
