// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Tells whether log modules are enabled or not. </summary>
    public readonly partial struct DynatraceLogModuleState : IEquatable<DynatraceLogModuleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynatraceLogModuleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynatraceLogModuleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "ENABLED";
        private const string DisabledValue = "DISABLED";

        /// <summary> ENABLED. </summary>
        public static DynatraceLogModuleState Enabled { get; } = new DynatraceLogModuleState(EnabledValue);
        /// <summary> DISABLED. </summary>
        public static DynatraceLogModuleState Disabled { get; } = new DynatraceLogModuleState(DisabledValue);
        /// <summary> Determines if two <see cref="DynatraceLogModuleState"/> values are the same. </summary>
        public static bool operator ==(DynatraceLogModuleState left, DynatraceLogModuleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynatraceLogModuleState"/> values are not the same. </summary>
        public static bool operator !=(DynatraceLogModuleState left, DynatraceLogModuleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynatraceLogModuleState"/>. </summary>
        public static implicit operator DynatraceLogModuleState(string value) => new DynatraceLogModuleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynatraceLogModuleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynatraceLogModuleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
