// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Properties of the Dynatrace environment. </summary>
    public partial class DynatraceEnvironmentProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DynatraceEnvironmentProperties"/>. </summary>
        public DynatraceEnvironmentProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DynatraceEnvironmentProperties"/>. </summary>
        /// <param name="userId"> User id. </param>
        /// <param name="accountInfo"> Dynatrace Account Information. </param>
        /// <param name="environmentInfo"> Dynatrace Environment Information. </param>
        /// <param name="singleSignOnProperties"> The details of a Dynatrace single sign-on. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DynatraceEnvironmentProperties(string userId, DynatraceAccountInfo accountInfo, DynatraceEnvironmentInfo environmentInfo, DynatraceSingleSignOnProperties singleSignOnProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserId = userId;
            AccountInfo = accountInfo;
            EnvironmentInfo = environmentInfo;
            SingleSignOnProperties = singleSignOnProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> User id. </summary>
        public string UserId { get; set; }
        /// <summary> Dynatrace Account Information. </summary>
        public DynatraceAccountInfo AccountInfo { get; set; }
        /// <summary> Dynatrace Environment Information. </summary>
        public DynatraceEnvironmentInfo EnvironmentInfo { get; set; }
        /// <summary> The details of a Dynatrace single sign-on. </summary>
        public DynatraceSingleSignOnProperties SingleSignOnProperties { get; set; }
    }
}
