// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Dynatrace.Models
{
    /// <summary> Indicates whether activity logs are being sent. </summary>
    public readonly partial struct ActivityLogsSendingStatus : IEquatable<ActivityLogsSendingStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ActivityLogsSendingStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ActivityLogsSendingStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static ActivityLogsSendingStatus Enabled { get; } = new ActivityLogsSendingStatus(EnabledValue);
        /// <summary> Disabled. </summary>
        public static ActivityLogsSendingStatus Disabled { get; } = new ActivityLogsSendingStatus(DisabledValue);
        /// <summary> Determines if two <see cref="ActivityLogsSendingStatus"/> values are the same. </summary>
        public static bool operator ==(ActivityLogsSendingStatus left, ActivityLogsSendingStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ActivityLogsSendingStatus"/> values are not the same. </summary>
        public static bool operator !=(ActivityLogsSendingStatus left, ActivityLogsSendingStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ActivityLogsSendingStatus"/>. </summary>
        public static implicit operator ActivityLogsSendingStatus(string value) => new ActivityLogsSendingStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ActivityLogsSendingStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ActivityLogsSendingStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
