// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Dynatrace
{
    internal class DynatraceSingleSignOnOperationSource : IOperationSource<DynatraceSingleSignOnResource>
    {
        private readonly ArmClient _client;

        internal DynatraceSingleSignOnOperationSource(ArmClient client)
        {
            _client = client;
        }

        DynatraceSingleSignOnResource IOperationSource<DynatraceSingleSignOnResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DynatraceSingleSignOnData.DeserializeDynatraceSingleSignOnData(document.RootElement);
            return new DynatraceSingleSignOnResource(_client, data);
        }

        async ValueTask<DynatraceSingleSignOnResource> IOperationSource<DynatraceSingleSignOnResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DynatraceSingleSignOnData.DeserializeDynatraceSingleSignOnData(document.RootElement);
            return new DynatraceSingleSignOnResource(_client, data);
        }
    }
}
