// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Dynatrace
{
    internal class DynatraceMonitorOperationSource : IOperationSource<DynatraceMonitorResource>
    {
        private readonly ArmClient _client;

        internal DynatraceMonitorOperationSource(ArmClient client)
        {
            _client = client;
        }

        DynatraceMonitorResource IOperationSource<DynatraceMonitorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DynatraceMonitorData.DeserializeDynatraceMonitorData(document.RootElement);
            return new DynatraceMonitorResource(_client, data);
        }

        async ValueTask<DynatraceMonitorResource> IOperationSource<DynatraceMonitorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DynatraceMonitorData.DeserializeDynatraceMonitorData(document.RootElement);
            return new DynatraceMonitorResource(_client, data);
        }
    }
}
