// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.AI.DocumentIntelligence.Samples
{
    public partial class Samples_DocumentIntelligenceAdministrationClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_AuthorizeModelCopy_AuthorizeCopyOfDocumentModel()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                modelId = "targetModel",
                description = "Target model description",
            });
            Response response = client.AuthorizeModelCopy(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("targetResourceId").ToString());
            Console.WriteLine(result.GetProperty("targetResourceRegion").ToString());
            Console.WriteLine(result.GetProperty("targetModelId").ToString());
            Console.WriteLine(result.GetProperty("targetModelLocation").ToString());
            Console.WriteLine(result.GetProperty("accessToken").ToString());
            Console.WriteLine(result.GetProperty("expirationDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_AuthorizeModelCopy_AuthorizeCopyOfDocumentModel_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                modelId = "targetModel",
                description = "Target model description",
            });
            Response response = await client.AuthorizeModelCopyAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("targetResourceId").ToString());
            Console.WriteLine(result.GetProperty("targetResourceRegion").ToString());
            Console.WriteLine(result.GetProperty("targetModelId").ToString());
            Console.WriteLine(result.GetProperty("targetModelLocation").ToString());
            Console.WriteLine(result.GetProperty("accessToken").ToString());
            Console.WriteLine(result.GetProperty("expirationDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_AuthorizeModelCopy_AuthorizeCopyOfDocumentModel_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            AuthorizeCopyContent authorizeCopyRequest = new AuthorizeCopyContent("targetModel")
            {
                Description = "Target model description",
            };
            Response<CopyAuthorization> response = client.AuthorizeModelCopy(authorizeCopyRequest);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_AuthorizeModelCopy_AuthorizeCopyOfDocumentModel_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            AuthorizeCopyContent authorizeCopyRequest = new AuthorizeCopyContent("targetModel")
            {
                Description = "Target model description",
            };
            Response<CopyAuthorization> response = await client.AuthorizeModelCopyAsync(authorizeCopyRequest);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentModelDetails_GetModel_GetCustomDocumentModel()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = client.GetModel("myCustomModel", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentModelDetails_GetModel_GetCustomDocumentModel_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = await client.GetModelAsync("myCustomModel", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentModelDetails_GetModel_GetCustomDocumentModel_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<DocumentModelDetails> response = client.GetModel("myCustomModel");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentModelDetails_GetModel_GetCustomDocumentModel_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<DocumentModelDetails> response = await client.GetModelAsync("myCustomModel");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentModelDetails_GetModel_GetPrebuiltDocumentModel()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = client.GetModel("prebuilt-invoice", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentModelDetails_GetModel_GetPrebuiltDocumentModel_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = await client.GetModelAsync("prebuilt-invoice", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentModelDetails_GetModel_GetPrebuiltDocumentModel_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<DocumentModelDetails> response = client.GetModel("prebuilt-invoice");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentModelDetails_GetModel_GetPrebuiltDocumentModel_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<DocumentModelDetails> response = await client.GetModelAsync("prebuilt-invoice");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentModelDetails_DeleteModel_DeleteDocumentModel()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = client.DeleteModel("myCustomModel");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentModelDetails_DeleteModel_DeleteDocumentModel_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = await client.DeleteModelAsync("myCustomModel");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_GetResourceInfo_GetResourceDetails()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = client.GetResourceInfo(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("customDocumentModels").GetProperty("count").ToString());
            Console.WriteLine(result.GetProperty("customDocumentModels").GetProperty("limit").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_GetResourceInfo_GetResourceDetails_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = await client.GetResourceInfoAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("customDocumentModels").GetProperty("count").ToString());
            Console.WriteLine(result.GetProperty("customDocumentModels").GetProperty("limit").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_GetResourceInfo_GetResourceDetails_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<ResourceDetails> response = client.GetResourceInfo();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_GetResourceInfo_GetResourceDetails_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<ResourceDetails> response = await client.GetResourceInfoAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_OperationDetails_GetOperation_GetOperation()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = client.GetOperation("b704bb00-d130-4f3f-a1d8-ca96de3eabb4", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("kind").ToString());
            Console.WriteLine(result.GetProperty("resourceLocation").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_OperationDetails_GetOperation_GetOperation_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = await client.GetOperationAsync("b704bb00-d130-4f3f-a1d8-ca96de3eabb4", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
            Console.WriteLine(result.GetProperty("kind").ToString());
            Console.WriteLine(result.GetProperty("resourceLocation").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_OperationDetails_GetOperation_GetOperation_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<OperationDetails> response = client.GetOperation("b704bb00-d130-4f3f-a1d8-ca96de3eabb4");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_OperationDetails_GetOperation_GetOperation_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<OperationDetails> response = await client.GetOperationAsync("b704bb00-d130-4f3f-a1d8-ca96de3eabb4");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_AuthorizeClassifierCopy_AuthorizeCopyOfDocumentClassifier()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                classifierId = "targetClassifier",
                description = "Target classifier description",
            });
            Response response = client.AuthorizeClassifierCopy(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("targetResourceId").ToString());
            Console.WriteLine(result.GetProperty("targetResourceRegion").ToString());
            Console.WriteLine(result.GetProperty("targetClassifierId").ToString());
            Console.WriteLine(result.GetProperty("targetClassifierLocation").ToString());
            Console.WriteLine(result.GetProperty("accessToken").ToString());
            Console.WriteLine(result.GetProperty("expirationDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_AuthorizeClassifierCopy_AuthorizeCopyOfDocumentClassifier_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                classifierId = "targetClassifier",
                description = "Target classifier description",
            });
            Response response = await client.AuthorizeClassifierCopyAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("targetResourceId").ToString());
            Console.WriteLine(result.GetProperty("targetResourceRegion").ToString());
            Console.WriteLine(result.GetProperty("targetClassifierId").ToString());
            Console.WriteLine(result.GetProperty("targetClassifierLocation").ToString());
            Console.WriteLine(result.GetProperty("accessToken").ToString());
            Console.WriteLine(result.GetProperty("expirationDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_AuthorizeClassifierCopy_AuthorizeCopyOfDocumentClassifier_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            AuthorizeClassifierCopyContent authorizeCopyRequest = new AuthorizeClassifierCopyContent("targetClassifier")
            {
                Description = "Target classifier description",
            };
            Response<ClassifierCopyAuthorization> response = client.AuthorizeClassifierCopy(authorizeCopyRequest);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_AuthorizeClassifierCopy_AuthorizeCopyOfDocumentClassifier_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            AuthorizeClassifierCopyContent authorizeCopyRequest = new AuthorizeClassifierCopyContent("targetClassifier")
            {
                Description = "Target classifier description",
            };
            Response<ClassifierCopyAuthorization> response = await client.AuthorizeClassifierCopyAsync(authorizeCopyRequest);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentClassifierDetails_GetClassifier_GetDocumentClassifier()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = client.GetClassifier("myClassifier", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("classifierId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("apiVersion").ToString());
            Console.WriteLine(result.GetProperty("docTypes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentClassifierDetails_GetClassifier_GetDocumentClassifier_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = await client.GetClassifierAsync("myClassifier", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("classifierId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("apiVersion").ToString());
            Console.WriteLine(result.GetProperty("docTypes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentClassifierDetails_GetClassifier_GetDocumentClassifier_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<DocumentClassifierDetails> response = client.GetClassifier("myClassifier");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentClassifierDetails_GetClassifier_GetDocumentClassifier_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response<DocumentClassifierDetails> response = await client.GetClassifierAsync("myClassifier");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentClassifierDetails_DeleteClassifier_DeleteDocumentClassifier()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = client.DeleteClassifier("myClassifier");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentClassifierDetails_DeleteClassifier_DeleteDocumentClassifier_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            Response response = await client.DeleteClassifierAsync("myClassifier");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentModelDetails_GetModels_GetDocumentModels()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            foreach (BinaryData item in client.GetModels(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("modelId").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentModelDetails_GetModels_GetDocumentModels_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            await foreach (BinaryData item in client.GetModelsAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("modelId").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentModelDetails_GetModels_GetDocumentModels_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            foreach (DocumentModelDetails item in client.GetModels())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentModelDetails_GetModels_GetDocumentModels_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            await foreach (DocumentModelDetails item in client.GetModelsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_OperationDetails_GetOperations_GetOperations()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            foreach (BinaryData item in client.GetOperations(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
                Console.WriteLine(result.GetProperty("kind").ToString());
                Console.WriteLine(result.GetProperty("resourceLocation").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_OperationDetails_GetOperations_GetOperations_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            await foreach (BinaryData item in client.GetOperationsAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("lastUpdatedDateTime").ToString());
                Console.WriteLine(result.GetProperty("kind").ToString());
                Console.WriteLine(result.GetProperty("resourceLocation").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_OperationDetails_GetOperations_GetOperations_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            foreach (OperationDetails item in client.GetOperations())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_OperationDetails_GetOperations_GetOperations_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            await foreach (OperationDetails item in client.GetOperationsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentClassifierDetails_GetClassifiers_GetDocumentClassifiers()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            foreach (BinaryData item in client.GetClassifiers(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("classifierId").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("apiVersion").ToString());
                Console.WriteLine(result.GetProperty("docTypes").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentClassifierDetails_GetClassifiers_GetDocumentClassifiers_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            await foreach (BinaryData item in client.GetClassifiersAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("classifierId").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("apiVersion").ToString());
                Console.WriteLine(result.GetProperty("docTypes").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentClassifierDetails_GetClassifiers_GetDocumentClassifiers_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            foreach (DocumentClassifierDetails item in client.GetClassifiers())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentClassifierDetails_GetClassifiers_GetDocumentClassifiers_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            await foreach (DocumentClassifierDetails item in client.GetClassifiersAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_BuildDocumentModel_BuildDocumentModel()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                modelId = "myCustomModel",
                description = "Custom model description",
                buildMode = "template",
                azureBlobSource = new
                {
                    containerUrl = "https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken",
                    prefix = "trainingDocs/",
                },
                tags = new
                {
                    createdBy = "myUserId",
                },
            });
            Operation<BinaryData> operation = client.BuildDocumentModel(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_BuildDocumentModel_BuildDocumentModel_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                modelId = "myCustomModel",
                description = "Custom model description",
                buildMode = "template",
                azureBlobSource = new
                {
                    containerUrl = "https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken",
                    prefix = "trainingDocs/",
                },
                tags = new
                {
                    createdBy = "myUserId",
                },
            });
            Operation<BinaryData> operation = await client.BuildDocumentModelAsync(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_BuildDocumentModel_BuildDocumentModel_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            BuildDocumentModelContent buildRequest = new BuildDocumentModelContent("myCustomModel", DocumentBuildMode.Template)
            {
                Description = "Custom model description",
                AzureBlobSource = new AzureBlobContentSource(new Uri("https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken"))
                {
                    Prefix = "trainingDocs/",
                },
                Tags =
{
["createdBy"] = "myUserId"
},
            };
            Operation<DocumentModelDetails> operation = client.BuildDocumentModel(WaitUntil.Completed, buildRequest);
            DocumentModelDetails responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_BuildDocumentModel_BuildDocumentModel_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            BuildDocumentModelContent buildRequest = new BuildDocumentModelContent("myCustomModel", DocumentBuildMode.Template)
            {
                Description = "Custom model description",
                AzureBlobSource = new AzureBlobContentSource(new Uri("https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken"))
                {
                    Prefix = "trainingDocs/",
                },
                Tags =
{
["createdBy"] = "myUserId"
},
            };
            Operation<DocumentModelDetails> operation = await client.BuildDocumentModelAsync(WaitUntil.Completed, buildRequest);
            DocumentModelDetails responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_ComposeModel_ComposeDocumentModel()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                modelId = "composedModel",
                description = "Composed model description",
                classifierId = "customClassifier",
                docTypes = new
                {
                    formA = new
                    {
                        modelId = "model1",
                    },
                    formB = new
                    {
                        modelId = "model2",
                    },
                },
            });
            Operation<BinaryData> operation = client.ComposeModel(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_ComposeModel_ComposeDocumentModel_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                modelId = "composedModel",
                description = "Composed model description",
                classifierId = "customClassifier",
                docTypes = new
                {
                    formA = new
                    {
                        modelId = "model1",
                    },
                    formB = new
                    {
                        modelId = "model2",
                    },
                },
            });
            Operation<BinaryData> operation = await client.ComposeModelAsync(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_ComposeModel_ComposeDocumentModel_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            ComposeDocumentModelContent composeRequest = new ComposeDocumentModelContent("composedModel", "customClassifier", new Dictionary<string, DocumentTypeDetails>
            {
                ["formA"] = new DocumentTypeDetails
                {
                    ModelId = "model1",
                },
                ["formB"] = new DocumentTypeDetails
                {
                    ModelId = "model2",
                }
            })
            {
                Description = "Composed model description",
            };
            Operation<DocumentModelDetails> operation = client.ComposeModel(WaitUntil.Completed, composeRequest);
            DocumentModelDetails responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_ComposeModel_ComposeDocumentModel_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            ComposeDocumentModelContent composeRequest = new ComposeDocumentModelContent("composedModel", "customClassifier", new Dictionary<string, DocumentTypeDetails>
            {
                ["formA"] = new DocumentTypeDetails
                {
                    ModelId = "model1",
                },
                ["formB"] = new DocumentTypeDetails
                {
                    ModelId = "model2",
                }
            })
            {
                Description = "Composed model description",
            };
            Operation<DocumentModelDetails> operation = await client.ComposeModelAsync(WaitUntil.Completed, composeRequest);
            DocumentModelDetails responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_CopyModelTo_CopyDocumentModelTo()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                targetResourceId = "/subscriptions/targetSub/resourceGroups/targetRG/providers/Microsoft.CognitiveServices/accounts/targetService",
                targetResourceRegion = "targetResourceRegion",
                targetModelId = "targetModel",
                targetModelLocation = "https://targetEndpoint.cognitiveservices.azure.com/documentintelligence/documentModels/targetModel",
                accessToken = "accessToken",
                expirationDateTime = "2021-09-23T09:12:54.552Z",
            });
            Operation<BinaryData> operation = client.CopyModelTo(WaitUntil.Completed, "sourceModel", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_CopyModelTo_CopyDocumentModelTo_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                targetResourceId = "/subscriptions/targetSub/resourceGroups/targetRG/providers/Microsoft.CognitiveServices/accounts/targetService",
                targetResourceRegion = "targetResourceRegion",
                targetModelId = "targetModel",
                targetModelLocation = "https://targetEndpoint.cognitiveservices.azure.com/documentintelligence/documentModels/targetModel",
                accessToken = "accessToken",
                expirationDateTime = "2021-09-23T09:12:54.552Z",
            });
            Operation<BinaryData> operation = await client.CopyModelToAsync(WaitUntil.Completed, "sourceModel", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("modelId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_CopyModelTo_CopyDocumentModelTo_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            CopyAuthorization copyToRequest = new CopyAuthorization(
                "/subscriptions/targetSub/resourceGroups/targetRG/providers/Microsoft.CognitiveServices/accounts/targetService",
                "targetResourceRegion",
                "targetModel",
                new Uri("https://targetEndpoint.cognitiveservices.azure.com/documentintelligence/documentModels/targetModel"),
                "accessToken",
                DateTimeOffset.Parse("2021-09-23T09:12:54.552Z"));
            Operation<DocumentModelDetails> operation = client.CopyModelTo(WaitUntil.Completed, "sourceModel", copyToRequest);
            DocumentModelDetails responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_CopyModelTo_CopyDocumentModelTo_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            CopyAuthorization copyToRequest = new CopyAuthorization(
                "/subscriptions/targetSub/resourceGroups/targetRG/providers/Microsoft.CognitiveServices/accounts/targetService",
                "targetResourceRegion",
                "targetModel",
                new Uri("https://targetEndpoint.cognitiveservices.azure.com/documentintelligence/documentModels/targetModel"),
                "accessToken",
                DateTimeOffset.Parse("2021-09-23T09:12:54.552Z"));
            Operation<DocumentModelDetails> operation = await client.CopyModelToAsync(WaitUntil.Completed, "sourceModel", copyToRequest);
            DocumentModelDetails responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_BuildClassifier_BuildDocumentClassifier()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                classifierId = "myClassifier",
                description = "Classifier description",
                docTypes = new
                {
                    formA = new
                    {
                        azureBlobSource = new
                        {
                            containerUrl = "https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken",
                            prefix = "formADocs/",
                        },
                    },
                    formB = new
                    {
                        azureBlobFileListSource = new
                        {
                            containerUrl = "https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken",
                            fileList = "formB.jsonl",
                        },
                    },
                },
            });
            Operation<BinaryData> operation = client.BuildClassifier(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("classifierId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("apiVersion").ToString());
            Console.WriteLine(result.GetProperty("docTypes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_BuildClassifier_BuildDocumentClassifier_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                classifierId = "myClassifier",
                description = "Classifier description",
                docTypes = new
                {
                    formA = new
                    {
                        azureBlobSource = new
                        {
                            containerUrl = "https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken",
                            prefix = "formADocs/",
                        },
                    },
                    formB = new
                    {
                        azureBlobFileListSource = new
                        {
                            containerUrl = "https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken",
                            fileList = "formB.jsonl",
                        },
                    },
                },
            });
            Operation<BinaryData> operation = await client.BuildClassifierAsync(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("classifierId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("apiVersion").ToString());
            Console.WriteLine(result.GetProperty("docTypes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_BuildClassifier_BuildDocumentClassifier_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            BuildDocumentClassifierContent buildRequest = new BuildDocumentClassifierContent("myClassifier", new Dictionary<string, ClassifierDocumentTypeDetails>
            {
                ["formA"] = new ClassifierDocumentTypeDetails
                {
                    AzureBlobSource = new AzureBlobContentSource(new Uri("https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken"))
                    {
                        Prefix = "formADocs/",
                    },
                },
                ["formB"] = new ClassifierDocumentTypeDetails
                {
                    AzureBlobFileListSource = new AzureBlobFileListContentSource(new Uri("https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken"), "formB.jsonl"),
                }
            })
            {
                Description = "Classifier description",
            };
            Operation<DocumentClassifierDetails> operation = client.BuildClassifier(WaitUntil.Completed, buildRequest);
            DocumentClassifierDetails responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_BuildClassifier_BuildDocumentClassifier_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            BuildDocumentClassifierContent buildRequest = new BuildDocumentClassifierContent("myClassifier", new Dictionary<string, ClassifierDocumentTypeDetails>
            {
                ["formA"] = new ClassifierDocumentTypeDetails
                {
                    AzureBlobSource = new AzureBlobContentSource(new Uri("https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken"))
                    {
                        Prefix = "formADocs/",
                    },
                },
                ["formB"] = new ClassifierDocumentTypeDetails
                {
                    AzureBlobFileListSource = new AzureBlobFileListContentSource(new Uri("https://myStorageAccount.blob.core.windows.net/myContainer?mySasToken"), "formB.jsonl"),
                }
            })
            {
                Description = "Classifier description",
            };
            Operation<DocumentClassifierDetails> operation = await client.BuildClassifierAsync(WaitUntil.Completed, buildRequest);
            DocumentClassifierDetails responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_CopyClassifierTo_CopyDocumentClassifierTo()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                targetResourceId = "/subscriptions/targetSub/resourceGroups/targetRG/providers/Microsoft.CognitiveServices/accounts/targetService",
                targetResourceRegion = "targetResourceRegion",
                targetClassifierId = "targetClassifier",
                targetClassifierLocation = "https://targetEndpoint.cognitiveservices.azure.com/documentintelligence/documentClassifiers/targetClassifier",
                accessToken = "accessToken",
                expirationDateTime = "2021-09-23T09:12:54.552Z",
            });
            Operation<BinaryData> operation = client.CopyClassifierTo(WaitUntil.Completed, "sourceClassifier", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("classifierId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("apiVersion").ToString());
            Console.WriteLine(result.GetProperty("docTypes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_CopyClassifierTo_CopyDocumentClassifierTo_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                targetResourceId = "/subscriptions/targetSub/resourceGroups/targetRG/providers/Microsoft.CognitiveServices/accounts/targetService",
                targetResourceRegion = "targetResourceRegion",
                targetClassifierId = "targetClassifier",
                targetClassifierLocation = "https://targetEndpoint.cognitiveservices.azure.com/documentintelligence/documentClassifiers/targetClassifier",
                accessToken = "accessToken",
                expirationDateTime = "2021-09-23T09:12:54.552Z",
            });
            Operation<BinaryData> operation = await client.CopyClassifierToAsync(WaitUntil.Completed, "sourceClassifier", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("classifierId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("apiVersion").ToString());
            Console.WriteLine(result.GetProperty("docTypes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentIntelligenceAdministrationClient_CopyClassifierTo_CopyDocumentClassifierTo_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            ClassifierCopyAuthorization copyToRequest = new ClassifierCopyAuthorization(
                "/subscriptions/targetSub/resourceGroups/targetRG/providers/Microsoft.CognitiveServices/accounts/targetService",
                "targetResourceRegion",
                "targetClassifier",
                new Uri("https://targetEndpoint.cognitiveservices.azure.com/documentintelligence/documentClassifiers/targetClassifier"),
                "accessToken",
                DateTimeOffset.Parse("2021-09-23T09:12:54.552Z"));
            Operation<DocumentClassifierDetails> operation = client.CopyClassifierTo(WaitUntil.Completed, "sourceClassifier", copyToRequest);
            DocumentClassifierDetails responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentIntelligenceAdministrationClient_CopyClassifierTo_CopyDocumentClassifierTo_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            DocumentIntelligenceAdministrationClient client = new DocumentIntelligenceAdministrationClient(endpoint, credential);

            ClassifierCopyAuthorization copyToRequest = new ClassifierCopyAuthorization(
                "/subscriptions/targetSub/resourceGroups/targetRG/providers/Microsoft.CognitiveServices/accounts/targetService",
                "targetResourceRegion",
                "targetClassifier",
                new Uri("https://targetEndpoint.cognitiveservices.azure.com/documentintelligence/documentClassifiers/targetClassifier"),
                "accessToken",
                DateTimeOffset.Parse("2021-09-23T09:12:54.552Z"));
            Operation<DocumentClassifierDetails> operation = await client.CopyClassifierToAsync(WaitUntil.Completed, "sourceClassifier", copyToRequest);
            DocumentClassifierDetails responseData = operation.Value;
        }
    }
}
