// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> An object representing the detected language for a given text span. </summary>
    public partial class DocumentLanguage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DocumentLanguage"/>. </summary>
        /// <param name="locale">
        /// Detected language.  Value may an ISO 639-1 language code (ex. "en", "fr")
        /// or BCP 47 language tag (ex. "zh-Hans").
        /// </param>
        /// <param name="spans">
        /// Location of the text elements in the concatenated content the language applies
        /// to.
        /// </param>
        /// <param name="confidence"> Confidence of correctly identifying the language. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="locale"/> or <paramref name="spans"/> is null. </exception>
        internal DocumentLanguage(string locale, IEnumerable<DocumentSpan> spans, float confidence)
        {
            Argument.AssertNotNull(locale, nameof(locale));
            Argument.AssertNotNull(spans, nameof(spans));

            Locale = locale;
            Spans = spans.ToList();
            Confidence = confidence;
        }

        /// <summary> Initializes a new instance of <see cref="DocumentLanguage"/>. </summary>
        /// <param name="locale">
        /// Detected language.  Value may an ISO 639-1 language code (ex. "en", "fr")
        /// or BCP 47 language tag (ex. "zh-Hans").
        /// </param>
        /// <param name="spans">
        /// Location of the text elements in the concatenated content the language applies
        /// to.
        /// </param>
        /// <param name="confidence"> Confidence of correctly identifying the language. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DocumentLanguage(string locale, IReadOnlyList<DocumentSpan> spans, float confidence, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Locale = locale;
            Spans = spans;
            Confidence = confidence;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DocumentLanguage"/> for deserialization. </summary>
        internal DocumentLanguage()
        {
        }

        /// <summary>
        /// Detected language.  Value may an ISO 639-1 language code (ex. "en", "fr")
        /// or BCP 47 language tag (ex. "zh-Hans").
        /// </summary>
        public string Locale { get; }
        /// <summary>
        /// Location of the text elements in the concatenated content the language applies
        /// to.
        /// </summary>
        public IReadOnlyList<DocumentSpan> Spans { get; }
        /// <summary> Confidence of correctly identifying the language. </summary>
        public float Confidence { get; }
    }
}
