// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Model factory for models. </summary>
    public static partial class DocumentIntelligenceModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentIntelligenceError"/>. </summary>
        /// <param name="code"> One of a server-defined set of error codes. </param>
        /// <param name="message"> A human-readable representation of the error. </param>
        /// <param name="target"> The target of the error. </param>
        /// <param name="details"> An array of details about specific errors that led to this reported error. </param>
        /// <param name="innererror"> An object containing more specific information than the current object about the error. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentIntelligenceError"/> instance for mocking. </returns>
        public static DocumentIntelligenceError DocumentIntelligenceError(string code = null, string message = null, string target = null, IEnumerable<DocumentIntelligenceError> details = null, InnerError innererror = null)
        {
            details ??= new List<DocumentIntelligenceError>();

            return new DocumentIntelligenceError(
                code,
                message,
                target,
                details?.ToList(),
                innererror,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.InnerError"/>. </summary>
        /// <param name="code"> One of a server-defined set of error codes. </param>
        /// <param name="message"> A human-readable representation of the error. </param>
        /// <param name="innerErrorObject"> Inner error. </param>
        /// <returns> A new <see cref="DocumentIntelligence.InnerError"/> instance for mocking. </returns>
        public static InnerError InnerError(string code = null, string message = null, InnerError innerErrorObject = null)
        {
            return new InnerError(code, message, innerErrorObject, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.AnalyzeResult"/>. </summary>
        /// <param name="apiVersion"> API version used to produce this result. </param>
        /// <param name="modelId"> Document model ID used to produce this result. </param>
        /// <param name="stringIndexType"> Method used to compute string offset and length. </param>
        /// <param name="contentFormat"> Format of the analyze result top-level content. </param>
        /// <param name="content">
        /// Concatenate string representation of all textual and visual elements in reading
        /// order.
        /// </param>
        /// <param name="pages"> Analyzed pages. </param>
        /// <param name="paragraphs"> Extracted paragraphs. </param>
        /// <param name="tables"> Extracted tables. </param>
        /// <param name="figures"> Extracted figures. </param>
        /// <param name="sections"> Extracted sections. </param>
        /// <param name="keyValuePairs"> Extracted key-value pairs. </param>
        /// <param name="styles"> Extracted font styles. </param>
        /// <param name="languages"> Detected languages. </param>
        /// <param name="documents"> Extracted documents. </param>
        /// <param name="warnings"> List of warnings encountered. </param>
        /// <returns> A new <see cref="DocumentIntelligence.AnalyzeResult"/> instance for mocking. </returns>
        public static AnalyzeResult AnalyzeResult(string apiVersion = null, string modelId = null, StringIndexType stringIndexType = default, ContentFormat? contentFormat = null, string content = null, IEnumerable<DocumentPage> pages = null, IEnumerable<DocumentParagraph> paragraphs = null, IEnumerable<DocumentTable> tables = null, IEnumerable<DocumentFigure> figures = null, IEnumerable<DocumentSection> sections = null, IEnumerable<DocumentKeyValuePair> keyValuePairs = null, IEnumerable<DocumentStyle> styles = null, IEnumerable<DocumentLanguage> languages = null, IEnumerable<AnalyzedDocument> documents = null, IEnumerable<DocumentIntelligenceWarning> warnings = null)
        {
            pages ??= new List<DocumentPage>();
            paragraphs ??= new List<DocumentParagraph>();
            tables ??= new List<DocumentTable>();
            figures ??= new List<DocumentFigure>();
            sections ??= new List<DocumentSection>();
            keyValuePairs ??= new List<DocumentKeyValuePair>();
            styles ??= new List<DocumentStyle>();
            languages ??= new List<DocumentLanguage>();
            documents ??= new List<AnalyzedDocument>();
            warnings ??= new List<DocumentIntelligenceWarning>();

            return new AnalyzeResult(
                apiVersion,
                modelId,
                stringIndexType,
                contentFormat,
                content,
                pages?.ToList(),
                paragraphs?.ToList(),
                tables?.ToList(),
                figures?.ToList(),
                sections?.ToList(),
                keyValuePairs?.ToList(),
                styles?.ToList(),
                languages?.ToList(),
                documents?.ToList(),
                warnings?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentPage"/>. </summary>
        /// <param name="pageNumber"> 1-based page number in the input document. </param>
        /// <param name="angle">
        /// The general orientation of the content in clockwise direction, measured in
        /// degrees between (-180, 180].
        /// </param>
        /// <param name="width"> The width of the image/PDF in pixels/inches, respectively. </param>
        /// <param name="height"> The height of the image/PDF in pixels/inches, respectively. </param>
        /// <param name="unit">
        /// The unit used by the width, height, and polygon properties. For images, the
        /// unit is "pixel". For PDF, the unit is "inch".
        /// </param>
        /// <param name="spans"> Location of the page in the reading order concatenated content. </param>
        /// <param name="words"> Extracted words from the page. </param>
        /// <param name="selectionMarks"> Extracted selection marks from the page. </param>
        /// <param name="lines">
        /// Extracted lines from the page, potentially containing both textual and visual
        /// elements.
        /// </param>
        /// <param name="barcodes"> Extracted barcodes from the page. </param>
        /// <param name="formulas"> Extracted formulas from the page. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentPage"/> instance for mocking. </returns>
        public static DocumentPage DocumentPage(int pageNumber = default, float? angle = null, float? width = null, float? height = null, LengthUnit? unit = null, IEnumerable<DocumentSpan> spans = null, IEnumerable<DocumentWord> words = null, IEnumerable<DocumentSelectionMark> selectionMarks = null, IEnumerable<DocumentLine> lines = null, IEnumerable<DocumentBarcode> barcodes = null, IEnumerable<DocumentFormula> formulas = null)
        {
            spans ??= new List<DocumentSpan>();
            words ??= new List<DocumentWord>();
            selectionMarks ??= new List<DocumentSelectionMark>();
            lines ??= new List<DocumentLine>();
            barcodes ??= new List<DocumentBarcode>();
            formulas ??= new List<DocumentFormula>();

            return new DocumentPage(
                pageNumber,
                angle,
                width,
                height,
                unit,
                spans?.ToList(),
                words?.ToList(),
                selectionMarks?.ToList(),
                lines?.ToList(),
                barcodes?.ToList(),
                formulas?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentSpan"/>. </summary>
        /// <param name="offset"> Zero-based index of the content represented by the span. </param>
        /// <param name="length"> Number of characters in the content represented by the span. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentSpan"/> instance for mocking. </returns>
        public static DocumentSpan DocumentSpan(int offset = default, int length = default)
        {
            return new DocumentSpan(offset, length, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentWord"/>. </summary>
        /// <param name="content"> Text content of the word. </param>
        /// <param name="polygon">
        /// Bounding polygon of the word, with coordinates specified relative to the
        /// top-left of the page. The numbers represent the x, y values of the polygon
        /// vertices, clockwise from the left (-180 degrees inclusive) relative to the
        /// element orientation.
        /// </param>
        /// <param name="span"> Location of the word in the reading order concatenated content. </param>
        /// <param name="confidence"> Confidence of correctly extracting the word. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentWord"/> instance for mocking. </returns>
        public static DocumentWord DocumentWord(string content = null, IEnumerable<float> polygon = null, DocumentSpan span = null, float confidence = default)
        {
            polygon ??= new List<float>();

            return new DocumentWord(content, polygon?.ToList(), span, confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentSelectionMark"/>. </summary>
        /// <param name="state"> State of the selection mark. </param>
        /// <param name="polygon">
        /// Bounding polygon of the selection mark, with coordinates specified relative
        /// to the top-left of the page. The numbers represent the x, y values of the
        /// polygon vertices, clockwise from the left (-180 degrees inclusive) relative
        /// to the element orientation.
        /// </param>
        /// <param name="span"> Location of the selection mark in the reading order concatenated content. </param>
        /// <param name="confidence"> Confidence of correctly extracting the selection mark. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentSelectionMark"/> instance for mocking. </returns>
        public static DocumentSelectionMark DocumentSelectionMark(DocumentSelectionMarkState state = default, IEnumerable<float> polygon = null, DocumentSpan span = null, float confidence = default)
        {
            polygon ??= new List<float>();

            return new DocumentSelectionMark(state, polygon?.ToList(), span, confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentLine"/>. </summary>
        /// <param name="content"> Concatenated content of the contained elements in reading order. </param>
        /// <param name="polygon">
        /// Bounding polygon of the line, with coordinates specified relative to the
        /// top-left of the page. The numbers represent the x, y values of the polygon
        /// vertices, clockwise from the left (-180 degrees inclusive) relative to the
        /// element orientation.
        /// </param>
        /// <param name="spans"> Location of the line in the reading order concatenated content. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentLine"/> instance for mocking. </returns>
        public static DocumentLine DocumentLine(string content = null, IEnumerable<float> polygon = null, IEnumerable<DocumentSpan> spans = null)
        {
            polygon ??= new List<float>();
            spans ??= new List<DocumentSpan>();

            return new DocumentLine(content, polygon?.ToList(), spans?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentBarcode"/>. </summary>
        /// <param name="kind"> Barcode kind. </param>
        /// <param name="value"> Barcode value. </param>
        /// <param name="polygon">
        /// Bounding polygon of the barcode, with coordinates specified relative to the
        /// top-left of the page. The numbers represent the x, y values of the polygon
        /// vertices, clockwise from the left (-180 degrees inclusive) relative to the
        /// element orientation.
        /// </param>
        /// <param name="span"> Location of the barcode in the reading order concatenated content. </param>
        /// <param name="confidence"> Confidence of correctly extracting the barcode. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentBarcode"/> instance for mocking. </returns>
        public static DocumentBarcode DocumentBarcode(DocumentBarcodeKind kind = default, string value = null, IEnumerable<float> polygon = null, DocumentSpan span = null, float confidence = default)
        {
            polygon ??= new List<float>();

            return new DocumentBarcode(
                kind,
                value,
                polygon?.ToList(),
                span,
                confidence,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentFormula"/>. </summary>
        /// <param name="kind"> Formula kind. </param>
        /// <param name="value"> LaTex expression describing the formula. </param>
        /// <param name="polygon">
        /// Bounding polygon of the formula, with coordinates specified relative to the
        /// top-left of the page. The numbers represent the x, y values of the polygon
        /// vertices, clockwise from the left (-180 degrees inclusive) relative to the
        /// element orientation.
        /// </param>
        /// <param name="span"> Location of the formula in the reading order concatenated content. </param>
        /// <param name="confidence"> Confidence of correctly extracting the formula. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentFormula"/> instance for mocking. </returns>
        public static DocumentFormula DocumentFormula(DocumentFormulaKind kind = default, string value = null, IEnumerable<float> polygon = null, DocumentSpan span = null, float confidence = default)
        {
            polygon ??= new List<float>();

            return new DocumentFormula(
                kind,
                value,
                polygon?.ToList(),
                span,
                confidence,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentParagraph"/>. </summary>
        /// <param name="role"> Semantic role of the paragraph. </param>
        /// <param name="content"> Concatenated content of the paragraph in reading order. </param>
        /// <param name="boundingRegions"> Bounding regions covering the paragraph. </param>
        /// <param name="spans"> Location of the paragraph in the reading order concatenated content. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentParagraph"/> instance for mocking. </returns>
        public static DocumentParagraph DocumentParagraph(ParagraphRole? role = null, string content = null, IEnumerable<BoundingRegion> boundingRegions = null, IEnumerable<DocumentSpan> spans = null)
        {
            boundingRegions ??= new List<BoundingRegion>();
            spans ??= new List<DocumentSpan>();

            return new DocumentParagraph(role, content, boundingRegions?.ToList(), spans?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.BoundingRegion"/>. </summary>
        /// <param name="pageNumber"> 1-based page number of page containing the bounding region. </param>
        /// <param name="polygon">
        /// Bounding polygon on the page, or the entire page if not specified.
        /// Coordinates specified relative to the top-left of the page. The numbers
        /// represent the x, y values of the polygon vertices, clockwise from the left
        /// (-180 degrees inclusive) relative to the element orientation.
        /// </param>
        /// <returns> A new <see cref="DocumentIntelligence.BoundingRegion"/> instance for mocking. </returns>
        public static BoundingRegion BoundingRegion(int pageNumber = default, IEnumerable<float> polygon = null)
        {
            polygon ??= new List<float>();

            return new BoundingRegion(pageNumber, polygon?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentTable"/>. </summary>
        /// <param name="rowCount"> Number of rows in the table. </param>
        /// <param name="columnCount"> Number of columns in the table. </param>
        /// <param name="cells"> Cells contained within the table. </param>
        /// <param name="boundingRegions"> Bounding regions covering the table. </param>
        /// <param name="spans"> Location of the table in the reading order concatenated content. </param>
        /// <param name="caption"> Caption associated with the table. </param>
        /// <param name="footnotes"> List of footnotes associated with the table. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentTable"/> instance for mocking. </returns>
        public static DocumentTable DocumentTable(int rowCount = default, int columnCount = default, IEnumerable<DocumentTableCell> cells = null, IEnumerable<BoundingRegion> boundingRegions = null, IEnumerable<DocumentSpan> spans = null, DocumentCaption caption = null, IEnumerable<DocumentFootnote> footnotes = null)
        {
            cells ??= new List<DocumentTableCell>();
            boundingRegions ??= new List<BoundingRegion>();
            spans ??= new List<DocumentSpan>();
            footnotes ??= new List<DocumentFootnote>();

            return new DocumentTable(
                rowCount,
                columnCount,
                cells?.ToList(),
                boundingRegions?.ToList(),
                spans?.ToList(),
                caption,
                footnotes?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentTableCell"/>. </summary>
        /// <param name="kind"> Table cell kind. </param>
        /// <param name="rowIndex"> Row index of the cell. </param>
        /// <param name="columnIndex"> Column index of the cell. </param>
        /// <param name="rowSpan"> Number of rows spanned by this cell. </param>
        /// <param name="columnSpan"> Number of columns spanned by this cell. </param>
        /// <param name="content"> Concatenated content of the table cell in reading order. </param>
        /// <param name="boundingRegions"> Bounding regions covering the table cell. </param>
        /// <param name="spans"> Location of the table cell in the reading order concatenated content. </param>
        /// <param name="elements"> Child elements of the table cell. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentTableCell"/> instance for mocking. </returns>
        public static DocumentTableCell DocumentTableCell(DocumentTableCellKind? kind = null, int rowIndex = default, int columnIndex = default, int? rowSpan = null, int? columnSpan = null, string content = null, IEnumerable<BoundingRegion> boundingRegions = null, IEnumerable<DocumentSpan> spans = null, IEnumerable<string> elements = null)
        {
            boundingRegions ??= new List<BoundingRegion>();
            spans ??= new List<DocumentSpan>();
            elements ??= new List<string>();

            return new DocumentTableCell(
                kind,
                rowIndex,
                columnIndex,
                rowSpan,
                columnSpan,
                content,
                boundingRegions?.ToList(),
                spans?.ToList(),
                elements?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentCaption"/>. </summary>
        /// <param name="content"> Content of the caption. </param>
        /// <param name="boundingRegions"> Bounding regions covering the caption. </param>
        /// <param name="spans"> Location of the caption in the reading order concatenated content. </param>
        /// <param name="elements"> Child elements of the caption. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentCaption"/> instance for mocking. </returns>
        public static DocumentCaption DocumentCaption(string content = null, IEnumerable<BoundingRegion> boundingRegions = null, IEnumerable<DocumentSpan> spans = null, IEnumerable<string> elements = null)
        {
            boundingRegions ??= new List<BoundingRegion>();
            spans ??= new List<DocumentSpan>();
            elements ??= new List<string>();

            return new DocumentCaption(content, boundingRegions?.ToList(), spans?.ToList(), elements?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentFootnote"/>. </summary>
        /// <param name="content"> Content of the footnote. </param>
        /// <param name="boundingRegions"> Bounding regions covering the footnote. </param>
        /// <param name="spans"> Location of the footnote in the reading order concatenated content. </param>
        /// <param name="elements"> Child elements of the footnote. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentFootnote"/> instance for mocking. </returns>
        public static DocumentFootnote DocumentFootnote(string content = null, IEnumerable<BoundingRegion> boundingRegions = null, IEnumerable<DocumentSpan> spans = null, IEnumerable<string> elements = null)
        {
            boundingRegions ??= new List<BoundingRegion>();
            spans ??= new List<DocumentSpan>();
            elements ??= new List<string>();

            return new DocumentFootnote(content, boundingRegions?.ToList(), spans?.ToList(), elements?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentFigure"/>. </summary>
        /// <param name="boundingRegions"> Bounding regions covering the figure. </param>
        /// <param name="spans"> Location of the figure in the reading order concatenated content. </param>
        /// <param name="elements"> Child elements of the figure, excluding any caption or footnotes. </param>
        /// <param name="caption"> Caption associated with the figure. </param>
        /// <param name="footnotes"> List of footnotes associated with the figure. </param>
        /// <param name="id"> Figure ID. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentFigure"/> instance for mocking. </returns>
        public static DocumentFigure DocumentFigure(IEnumerable<BoundingRegion> boundingRegions = null, IEnumerable<DocumentSpan> spans = null, IEnumerable<string> elements = null, DocumentCaption caption = null, IEnumerable<DocumentFootnote> footnotes = null, string id = null)
        {
            boundingRegions ??= new List<BoundingRegion>();
            spans ??= new List<DocumentSpan>();
            elements ??= new List<string>();
            footnotes ??= new List<DocumentFootnote>();

            return new DocumentFigure(
                boundingRegions?.ToList(),
                spans?.ToList(),
                elements?.ToList(),
                caption,
                footnotes?.ToList(),
                id,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentSection"/>. </summary>
        /// <param name="spans"> Location of the section in the reading order concatenated content. </param>
        /// <param name="elements"> Child elements of the section. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentSection"/> instance for mocking. </returns>
        public static DocumentSection DocumentSection(IEnumerable<DocumentSpan> spans = null, IEnumerable<string> elements = null)
        {
            spans ??= new List<DocumentSpan>();
            elements ??= new List<string>();

            return new DocumentSection(spans?.ToList(), elements?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentKeyValuePair"/>. </summary>
        /// <param name="key"> Field label of the key-value pair. </param>
        /// <param name="value"> Field value of the key-value pair. </param>
        /// <param name="confidence"> Confidence of correctly extracting the key-value pair. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentKeyValuePair"/> instance for mocking. </returns>
        public static DocumentKeyValuePair DocumentKeyValuePair(DocumentKeyValueElement key = null, DocumentKeyValueElement value = null, float confidence = default)
        {
            return new DocumentKeyValuePair(key, value, confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentKeyValueElement"/>. </summary>
        /// <param name="content"> Concatenated content of the key-value element in reading order. </param>
        /// <param name="boundingRegions"> Bounding regions covering the key-value element. </param>
        /// <param name="spans"> Location of the key-value element in the reading order concatenated content. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentKeyValueElement"/> instance for mocking. </returns>
        public static DocumentKeyValueElement DocumentKeyValueElement(string content = null, IEnumerable<BoundingRegion> boundingRegions = null, IEnumerable<DocumentSpan> spans = null)
        {
            boundingRegions ??= new List<BoundingRegion>();
            spans ??= new List<DocumentSpan>();

            return new DocumentKeyValueElement(content, boundingRegions?.ToList(), spans?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentStyle"/>. </summary>
        /// <param name="isHandwritten"> Is content handwritten?. </param>
        /// <param name="similarFontFamily">
        /// Visually most similar font from among the set of supported font families, with
        /// fallback fonts following CSS convention (ex. 'Arial, sans-serif').
        /// </param>
        /// <param name="fontStyle"> Font style. </param>
        /// <param name="fontWeight"> Font weight. </param>
        /// <param name="color"> Foreground color in #rrggbb hexadecimal format. </param>
        /// <param name="backgroundColor"> Background color in #rrggbb hexadecimal format.. </param>
        /// <param name="spans"> Location of the text elements in the concatenated content the style applies to. </param>
        /// <param name="confidence"> Confidence of correctly identifying the style. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentStyle"/> instance for mocking. </returns>
        public static DocumentStyle DocumentStyle(bool? isHandwritten = null, string similarFontFamily = null, DocumentFontStyle? fontStyle = null, DocumentFontWeight? fontWeight = null, string color = null, string backgroundColor = null, IEnumerable<DocumentSpan> spans = null, float confidence = default)
        {
            spans ??= new List<DocumentSpan>();

            return new DocumentStyle(
                isHandwritten,
                similarFontFamily,
                fontStyle,
                fontWeight,
                color,
                backgroundColor,
                spans?.ToList(),
                confidence,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentLanguage"/>. </summary>
        /// <param name="locale">
        /// Detected language.  Value may an ISO 639-1 language code (ex. "en", "fr")
        /// or BCP 47 language tag (ex. "zh-Hans").
        /// </param>
        /// <param name="spans">
        /// Location of the text elements in the concatenated content the language applies
        /// to.
        /// </param>
        /// <param name="confidence"> Confidence of correctly identifying the language. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentLanguage"/> instance for mocking. </returns>
        public static DocumentLanguage DocumentLanguage(string locale = null, IEnumerable<DocumentSpan> spans = null, float confidence = default)
        {
            spans ??= new List<DocumentSpan>();

            return new DocumentLanguage(locale, spans?.ToList(), confidence, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.AnalyzedDocument"/>. </summary>
        /// <param name="docType"> Document type. </param>
        /// <param name="boundingRegions"> Bounding regions covering the document. </param>
        /// <param name="spans"> Location of the document in the reading order concatenated content. </param>
        /// <param name="fields"> Dictionary of named field values. </param>
        /// <param name="confidence"> Confidence of correctly extracting the document. </param>
        /// <returns> A new <see cref="DocumentIntelligence.AnalyzedDocument"/> instance for mocking. </returns>
        public static AnalyzedDocument AnalyzedDocument(string docType = null, IEnumerable<BoundingRegion> boundingRegions = null, IEnumerable<DocumentSpan> spans = null, IReadOnlyDictionary<string, DocumentField> fields = null, float confidence = default)
        {
            boundingRegions ??= new List<BoundingRegion>();
            spans ??= new List<DocumentSpan>();
            fields ??= new Dictionary<string, DocumentField>();

            return new AnalyzedDocument(
                docType,
                boundingRegions?.ToList(),
                spans?.ToList(),
                fields,
                confidence,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentField"/>. </summary>
        /// <param name="type"> Data type of the field value. </param>
        /// <param name="valueString"> String value. </param>
        /// <param name="valueDate"> Date value in YYYY-MM-DD format (ISO 8601). </param>
        /// <param name="valueTime"> Time value in hh:mm:ss format (ISO 8601). </param>
        /// <param name="valuePhoneNumber"> Phone number value in E.164 format (ex. +19876543210). </param>
        /// <param name="valueDouble"> Floating point value. </param>
        /// <param name="valueLong"> Integer value. </param>
        /// <param name="valueSelectionMark"> Selection mark value. </param>
        /// <param name="valueSignature"> Presence of signature. </param>
        /// <param name="valueCountryRegion"> 3-letter country code value (ISO 3166-1 alpha-3). </param>
        /// <param name="valueList"> Array of field values. </param>
        /// <param name="valueDictionary"> Dictionary of named field values. </param>
        /// <param name="valueCurrency"> Currency value. </param>
        /// <param name="valueAddress"> Address value. </param>
        /// <param name="valueBoolean"> Boolean value. </param>
        /// <param name="valueSelectionGroup"> Selection group value. </param>
        /// <param name="content"> Field content. </param>
        /// <param name="boundingRegions"> Bounding regions covering the field. </param>
        /// <param name="spans"> Location of the field in the reading order concatenated content. </param>
        /// <param name="confidence"> Confidence of correctly extracting the field. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentField"/> instance for mocking. </returns>
        public static DocumentField DocumentField(DocumentFieldType type = default, string valueString = null, DateTimeOffset? valueDate = null, TimeSpan? valueTime = null, string valuePhoneNumber = null, double? valueDouble = null, long? valueLong = null, DocumentSelectionMarkState? valueSelectionMark = null, DocumentSignatureType? valueSignature = null, string valueCountryRegion = null, IEnumerable<DocumentField> valueList = null, IReadOnlyDictionary<string, DocumentField> valueDictionary = null, CurrencyValue valueCurrency = null, AddressValue valueAddress = null, bool? valueBoolean = null, IEnumerable<string> valueSelectionGroup = null, string content = null, IEnumerable<BoundingRegion> boundingRegions = null, IEnumerable<DocumentSpan> spans = null, float? confidence = null)
        {
            valueList ??= new List<DocumentField>();
            valueDictionary ??= new Dictionary<string, DocumentField>();
            valueSelectionGroup ??= new List<string>();
            boundingRegions ??= new List<BoundingRegion>();
            spans ??= new List<DocumentSpan>();

            return new DocumentField(
                type,
                valueString,
                valueDate,
                valueTime,
                valuePhoneNumber,
                valueDouble,
                valueLong,
                valueSelectionMark,
                valueSignature,
                valueCountryRegion,
                valueList?.ToList(),
                valueDictionary,
                valueCurrency,
                valueAddress,
                valueBoolean,
                valueSelectionGroup?.ToList(),
                content,
                boundingRegions?.ToList(),
                spans?.ToList(),
                confidence,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.CurrencyValue"/>. </summary>
        /// <param name="amount"> Currency amount. </param>
        /// <param name="currencySymbol"> Currency symbol label, if any. </param>
        /// <param name="currencyCode"> Resolved currency code (ISO 4217), if any. </param>
        /// <returns> A new <see cref="DocumentIntelligence.CurrencyValue"/> instance for mocking. </returns>
        public static CurrencyValue CurrencyValue(double amount = default, string currencySymbol = null, string currencyCode = null)
        {
            return new CurrencyValue(amount, currencySymbol, currencyCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.AddressValue"/>. </summary>
        /// <param name="houseNumber"> House or building number. </param>
        /// <param name="poBox"> Post office box number. </param>
        /// <param name="road"> Street name. </param>
        /// <param name="city"> Name of city, town, village, etc. </param>
        /// <param name="state"> First-level administrative division. </param>
        /// <param name="postalCode"> Postal code used for mail sorting. </param>
        /// <param name="countryRegion"> Country/region. </param>
        /// <param name="streetAddress"> Street-level address, excluding city, state, countryRegion, and postalCode. </param>
        /// <param name="unit"> Apartment or office number. </param>
        /// <param name="cityDistrict">
        /// Districts or boroughs within a city, such as Brooklyn in New York City or City
        /// of Westminster in London.
        /// </param>
        /// <param name="stateDistrict"> Second-level administrative division used in certain locales. </param>
        /// <param name="suburb"> Unofficial neighborhood name, like Chinatown. </param>
        /// <param name="house"> Build name, such as World Trade Center. </param>
        /// <param name="level"> Floor number, such as 3F. </param>
        /// <returns> A new <see cref="DocumentIntelligence.AddressValue"/> instance for mocking. </returns>
        public static AddressValue AddressValue(string houseNumber = null, string poBox = null, string road = null, string city = null, string state = null, string postalCode = null, string countryRegion = null, string streetAddress = null, string unit = null, string cityDistrict = null, string stateDistrict = null, string suburb = null, string house = null, string level = null)
        {
            return new AddressValue(
                houseNumber,
                poBox,
                road,
                city,
                state,
                postalCode,
                countryRegion,
                streetAddress,
                unit,
                cityDistrict,
                stateDistrict,
                suburb,
                house,
                level,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentIntelligenceWarning"/>. </summary>
        /// <param name="code"> One of a server-defined set of warning codes. </param>
        /// <param name="message"> A human-readable representation of the warning. </param>
        /// <param name="target"> The target of the error. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentIntelligenceWarning"/> instance for mocking. </returns>
        public static DocumentIntelligenceWarning DocumentIntelligenceWarning(string code = null, string message = null, string target = null)
        {
            return new DocumentIntelligenceWarning(code, message, target, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.AnalyzeBatchDocumentsContent"/>. </summary>
        /// <param name="azureBlobSource">
        /// Azure Blob Storage location containing the batch documents.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </param>
        /// <param name="azureBlobFileListSource">
        /// Azure Blob Storage file list specifying the batch documents.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </param>
        /// <param name="resultContainerUrl"> Azure Blob Storage container URL where analyze result files will be stored. </param>
        /// <param name="resultPrefix"> Blob name prefix of result files. </param>
        /// <param name="overwriteExisting"> Overwrite existing analyze result files?. </param>
        /// <returns> A new <see cref="DocumentIntelligence.AnalyzeBatchDocumentsContent"/> instance for mocking. </returns>
        public static AnalyzeBatchDocumentsContent AnalyzeBatchDocumentsContent(AzureBlobContentSource azureBlobSource = null, AzureBlobFileListContentSource azureBlobFileListSource = null, Uri resultContainerUrl = null, string resultPrefix = null, bool? overwriteExisting = null)
        {
            return new AnalyzeBatchDocumentsContent(
                azureBlobSource,
                azureBlobFileListSource,
                resultContainerUrl,
                resultPrefix,
                overwriteExisting,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.AnalyzeBatchResult"/>. </summary>
        /// <param name="succeededCount"> Number of documents that completed with status succeeded. </param>
        /// <param name="failedCount"> Number of documents that completed with status failed. </param>
        /// <param name="skippedCount"> Number of documents that completed with status skipped. </param>
        /// <param name="details"> Operation detail for each document in the batch. </param>
        /// <returns> A new <see cref="DocumentIntelligence.AnalyzeBatchResult"/> instance for mocking. </returns>
        public static AnalyzeBatchResult AnalyzeBatchResult(int succeededCount = default, int failedCount = default, int skippedCount = default, IEnumerable<AnalyzeBatchOperationDetail> details = null)
        {
            details ??= new List<AnalyzeBatchOperationDetail>();

            return new AnalyzeBatchResult(succeededCount, failedCount, skippedCount, details?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.AnalyzeBatchOperationDetail"/>. </summary>
        /// <param name="status"> Analyze status.  succeeded, failed, or skipped. </param>
        /// <param name="sourceUrl"> URL of the source document. </param>
        /// <param name="resultUrl"> URL of the analyze result JSON. </param>
        /// <param name="error"> Encountered error. </param>
        /// <returns> A new <see cref="DocumentIntelligence.AnalyzeBatchOperationDetail"/> instance for mocking. </returns>
        public static AnalyzeBatchOperationDetail AnalyzeBatchOperationDetail(OperationStatus status = default, Uri sourceUrl = null, Uri resultUrl = null, DocumentIntelligenceError error = null)
        {
            return new AnalyzeBatchOperationDetail(status, sourceUrl, resultUrl, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.BuildDocumentModelContent"/>. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="description"> Document model description. </param>
        /// <param name="buildMode"> Custom document model build mode. </param>
        /// <param name="azureBlobSource">
        /// Azure Blob Storage location containing the training data.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </param>
        /// <param name="azureBlobFileListSource">
        /// Azure Blob Storage file list specifying the training data.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <param name="maxTrainingHours"> Max number of V100-equivalent GPU hours to use for model training.  Default=0.5. </param>
        /// <param name="allowOverwrite"> Allow overwriting an existing model with the same name. </param>
        /// <returns> A new <see cref="DocumentIntelligence.BuildDocumentModelContent"/> instance for mocking. </returns>
        public static BuildDocumentModelContent BuildDocumentModelContent(string modelId = null, string description = null, DocumentBuildMode buildMode = default, AzureBlobContentSource azureBlobSource = null, AzureBlobFileListContentSource azureBlobFileListSource = null, IDictionary<string, string> tags = null, float? maxTrainingHours = null, bool? allowOverwrite = null)
        {
            tags ??= new Dictionary<string, string>();

            return new BuildDocumentModelContent(
                modelId,
                description,
                buildMode,
                azureBlobSource,
                azureBlobFileListSource,
                tags,
                maxTrainingHours,
                allowOverwrite,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentModelDetails"/>. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="description"> Document model description. </param>
        /// <param name="createdOn"> Date and time (UTC) when the document model was created. </param>
        /// <param name="expiresOn"> Date and time (UTC) when the document model will expire. </param>
        /// <param name="apiVersion"> API version used to create this document model. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <param name="buildMode"> Custom document model build mode. </param>
        /// <param name="azureBlobSource">
        /// Azure Blob Storage location containing the training data.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </param>
        /// <param name="azureBlobFileListSource">
        /// Azure Blob Storage file list specifying the training data.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </param>
        /// <param name="classifierId"> For composed models, the custom classifier to split and classify the input file. </param>
        /// <param name="split"> For composed models, the file splitting behavior. </param>
        /// <param name="docTypes"> Supported document types. </param>
        /// <param name="warnings"> List of warnings encountered while building the model. </param>
        /// <param name="trainingHours"> Number of V100-equivalent GPU hours consumed for model training. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentModelDetails"/> instance for mocking. </returns>
        public static DocumentModelDetails DocumentModelDetails(string modelId = null, string description = null, DateTimeOffset createdOn = default, DateTimeOffset? expiresOn = null, string apiVersion = null, IReadOnlyDictionary<string, string> tags = null, DocumentBuildMode? buildMode = null, AzureBlobContentSource azureBlobSource = null, AzureBlobFileListContentSource azureBlobFileListSource = null, string classifierId = null, SplitMode? split = null, IReadOnlyDictionary<string, DocumentTypeDetails> docTypes = null, IEnumerable<DocumentIntelligenceWarning> warnings = null, float? trainingHours = null)
        {
            tags ??= new Dictionary<string, string>();
            docTypes ??= new Dictionary<string, DocumentTypeDetails>();
            warnings ??= new List<DocumentIntelligenceWarning>();

            return new DocumentModelDetails(
                modelId,
                description,
                createdOn,
                expiresOn,
                apiVersion,
                tags,
                buildMode,
                azureBlobSource,
                azureBlobFileListSource,
                classifierId,
                split,
                docTypes,
                warnings?.ToList(),
                trainingHours,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentModelBuildOperationDetails"/>. </summary>
        /// <param name="operationId"> Operation ID. </param>
        /// <param name="status"> Operation status.  notStarted, running, completed, or failed. </param>
        /// <param name="percentCompleted"> Operation progress (0-100). </param>
        /// <param name="createdOn"> Date and time (UTC) when the operation was created. </param>
        /// <param name="lastUpdatedOn"> Date and time (UTC) when the status was last updated. </param>
        /// <param name="resourceLocation"> URL of the resource targeted by this operation. </param>
        /// <param name="apiVersion"> API version used to create this operation. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <param name="error"> Encountered error. </param>
        /// <param name="result"> Operation result upon success. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentModelBuildOperationDetails"/> instance for mocking. </returns>
        public static DocumentModelBuildOperationDetails DocumentModelBuildOperationDetails(string operationId = null, OperationStatus status = default, int? percentCompleted = null, DateTimeOffset createdOn = default, DateTimeOffset lastUpdatedOn = default, Uri resourceLocation = null, string apiVersion = null, IReadOnlyDictionary<string, string> tags = null, DocumentIntelligenceError error = null, DocumentModelDetails result = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DocumentModelBuildOperationDetails(
                operationId,
                status,
                percentCompleted,
                createdOn,
                lastUpdatedOn,
                OperationKind.DocumentModelBuild,
                resourceLocation,
                apiVersion,
                tags,
                error,
                serializedAdditionalRawData: null,
                result);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.OperationDetails"/>. </summary>
        /// <param name="operationId"> Operation ID. </param>
        /// <param name="status"> Operation status.  notStarted, running, completed, or failed. </param>
        /// <param name="percentCompleted"> Operation progress (0-100). </param>
        /// <param name="createdOn"> Date and time (UTC) when the operation was created. </param>
        /// <param name="lastUpdatedOn"> Date and time (UTC) when the status was last updated. </param>
        /// <param name="kind"> Type of operation. </param>
        /// <param name="resourceLocation"> URL of the resource targeted by this operation. </param>
        /// <param name="apiVersion"> API version used to create this operation. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <param name="error"> Encountered error. </param>
        /// <returns> A new <see cref="DocumentIntelligence.OperationDetails"/> instance for mocking. </returns>
        public static OperationDetails OperationDetails(string operationId = null, OperationStatus status = default, int? percentCompleted = null, DateTimeOffset createdOn = default, DateTimeOffset lastUpdatedOn = default, string kind = null, Uri resourceLocation = null, string apiVersion = null, IReadOnlyDictionary<string, string> tags = null, DocumentIntelligenceError error = null)
        {
            tags ??= new Dictionary<string, string>();

            return new UnknownOperationDetails(
                operationId,
                status,
                percentCompleted,
                createdOn,
                lastUpdatedOn,
                kind == null ? default : new OperationKind(kind),
                resourceLocation,
                apiVersion,
                tags,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentModelComposeOperationDetails"/>. </summary>
        /// <param name="operationId"> Operation ID. </param>
        /// <param name="status"> Operation status.  notStarted, running, completed, or failed. </param>
        /// <param name="percentCompleted"> Operation progress (0-100). </param>
        /// <param name="createdOn"> Date and time (UTC) when the operation was created. </param>
        /// <param name="lastUpdatedOn"> Date and time (UTC) when the status was last updated. </param>
        /// <param name="resourceLocation"> URL of the resource targeted by this operation. </param>
        /// <param name="apiVersion"> API version used to create this operation. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <param name="error"> Encountered error. </param>
        /// <param name="result"> Operation result upon success. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentModelComposeOperationDetails"/> instance for mocking. </returns>
        public static DocumentModelComposeOperationDetails DocumentModelComposeOperationDetails(string operationId = null, OperationStatus status = default, int? percentCompleted = null, DateTimeOffset createdOn = default, DateTimeOffset lastUpdatedOn = default, Uri resourceLocation = null, string apiVersion = null, IReadOnlyDictionary<string, string> tags = null, DocumentIntelligenceError error = null, DocumentModelDetails result = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DocumentModelComposeOperationDetails(
                operationId,
                status,
                percentCompleted,
                createdOn,
                lastUpdatedOn,
                OperationKind.DocumentModelCompose,
                resourceLocation,
                apiVersion,
                tags,
                error,
                serializedAdditionalRawData: null,
                result);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentModelCopyToOperationDetails"/>. </summary>
        /// <param name="operationId"> Operation ID. </param>
        /// <param name="status"> Operation status.  notStarted, running, completed, or failed. </param>
        /// <param name="percentCompleted"> Operation progress (0-100). </param>
        /// <param name="createdOn"> Date and time (UTC) when the operation was created. </param>
        /// <param name="lastUpdatedOn"> Date and time (UTC) when the status was last updated. </param>
        /// <param name="resourceLocation"> URL of the resource targeted by this operation. </param>
        /// <param name="apiVersion"> API version used to create this operation. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <param name="error"> Encountered error. </param>
        /// <param name="result"> Operation result upon success. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentModelCopyToOperationDetails"/> instance for mocking. </returns>
        public static DocumentModelCopyToOperationDetails DocumentModelCopyToOperationDetails(string operationId = null, OperationStatus status = default, int? percentCompleted = null, DateTimeOffset createdOn = default, DateTimeOffset lastUpdatedOn = default, Uri resourceLocation = null, string apiVersion = null, IReadOnlyDictionary<string, string> tags = null, DocumentIntelligenceError error = null, DocumentModelDetails result = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DocumentModelCopyToOperationDetails(
                operationId,
                status,
                percentCompleted,
                createdOn,
                lastUpdatedOn,
                OperationKind.DocumentModelCopyTo,
                resourceLocation,
                apiVersion,
                tags,
                error,
                serializedAdditionalRawData: null,
                result);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentClassifierCopyToOperationDetails"/>. </summary>
        /// <param name="operationId"> Operation ID. </param>
        /// <param name="status"> Operation status.  notStarted, running, completed, or failed. </param>
        /// <param name="percentCompleted"> Operation progress (0-100). </param>
        /// <param name="createdOn"> Date and time (UTC) when the operation was created. </param>
        /// <param name="lastUpdatedOn"> Date and time (UTC) when the status was last updated. </param>
        /// <param name="resourceLocation"> URL of the resource targeted by this operation. </param>
        /// <param name="apiVersion"> API version used to create this operation. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <param name="error"> Encountered error. </param>
        /// <param name="result"> Operation result upon success. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentClassifierCopyToOperationDetails"/> instance for mocking. </returns>
        public static DocumentClassifierCopyToOperationDetails DocumentClassifierCopyToOperationDetails(string operationId = null, OperationStatus status = default, int? percentCompleted = null, DateTimeOffset createdOn = default, DateTimeOffset lastUpdatedOn = default, Uri resourceLocation = null, string apiVersion = null, IReadOnlyDictionary<string, string> tags = null, DocumentIntelligenceError error = null, DocumentClassifierDetails result = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DocumentClassifierCopyToOperationDetails(
                operationId,
                status,
                percentCompleted,
                createdOn,
                lastUpdatedOn,
                OperationKind.DocumentClassifierCopyTo,
                resourceLocation,
                apiVersion,
                tags,
                error,
                serializedAdditionalRawData: null,
                result);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentClassifierDetails"/>. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="description"> Document classifier description. </param>
        /// <param name="createdOn"> Date and time (UTC) when the document classifier was created. </param>
        /// <param name="expiresOn"> Date and time (UTC) when the document classifier will expire. </param>
        /// <param name="apiVersion"> API version used to create this document classifier. </param>
        /// <param name="baseClassifierId"> Base classifierId on top of which the classifier was trained. </param>
        /// <param name="docTypes"> List of document types to classify against. </param>
        /// <param name="warnings"> List of warnings encountered while building the classifier. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentClassifierDetails"/> instance for mocking. </returns>
        public static DocumentClassifierDetails DocumentClassifierDetails(string classifierId = null, string description = null, DateTimeOffset createdOn = default, DateTimeOffset? expiresOn = null, string apiVersion = null, string baseClassifierId = null, IReadOnlyDictionary<string, ClassifierDocumentTypeDetails> docTypes = null, IEnumerable<DocumentIntelligenceWarning> warnings = null)
        {
            docTypes ??= new Dictionary<string, ClassifierDocumentTypeDetails>();
            warnings ??= new List<DocumentIntelligenceWarning>();

            return new DocumentClassifierDetails(
                classifierId,
                description,
                createdOn,
                expiresOn,
                apiVersion,
                baseClassifierId,
                docTypes,
                warnings?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.DocumentClassifierBuildOperationDetails"/>. </summary>
        /// <param name="operationId"> Operation ID. </param>
        /// <param name="status"> Operation status.  notStarted, running, completed, or failed. </param>
        /// <param name="percentCompleted"> Operation progress (0-100). </param>
        /// <param name="createdOn"> Date and time (UTC) when the operation was created. </param>
        /// <param name="lastUpdatedOn"> Date and time (UTC) when the status was last updated. </param>
        /// <param name="resourceLocation"> URL of the resource targeted by this operation. </param>
        /// <param name="apiVersion"> API version used to create this operation. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <param name="error"> Encountered error. </param>
        /// <param name="result"> Operation result upon success. </param>
        /// <returns> A new <see cref="DocumentIntelligence.DocumentClassifierBuildOperationDetails"/> instance for mocking. </returns>
        public static DocumentClassifierBuildOperationDetails DocumentClassifierBuildOperationDetails(string operationId = null, OperationStatus status = default, int? percentCompleted = null, DateTimeOffset createdOn = default, DateTimeOffset lastUpdatedOn = default, Uri resourceLocation = null, string apiVersion = null, IReadOnlyDictionary<string, string> tags = null, DocumentIntelligenceError error = null, DocumentClassifierDetails result = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DocumentClassifierBuildOperationDetails(
                operationId,
                status,
                percentCompleted,
                createdOn,
                lastUpdatedOn,
                OperationKind.DocumentClassifierBuild,
                resourceLocation,
                apiVersion,
                tags,
                error,
                serializedAdditionalRawData: null,
                result);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.ComposeDocumentModelContent"/>. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="description"> Document model description. </param>
        /// <param name="classifierId"> Custom classifier to split and classify the input file. </param>
        /// <param name="split"> File splitting behavior. </param>
        /// <param name="docTypes"> Dictionary mapping supported docTypes to the corresponding document models. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <returns> A new <see cref="DocumentIntelligence.ComposeDocumentModelContent"/> instance for mocking. </returns>
        public static ComposeDocumentModelContent ComposeDocumentModelContent(string modelId = null, string description = null, string classifierId = null, SplitMode? split = null, IDictionary<string, DocumentTypeDetails> docTypes = null, IDictionary<string, string> tags = null)
        {
            docTypes ??= new Dictionary<string, DocumentTypeDetails>();
            tags ??= new Dictionary<string, string>();

            return new ComposeDocumentModelContent(
                modelId,
                description,
                classifierId,
                split,
                docTypes,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.AuthorizeCopyContent"/>. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="description"> Document model description. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <returns> A new <see cref="DocumentIntelligence.AuthorizeCopyContent"/> instance for mocking. </returns>
        public static AuthorizeCopyContent AuthorizeCopyContent(string modelId = null, string description = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AuthorizeCopyContent(modelId, description, tags, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.ResourceDetails"/>. </summary>
        /// <param name="customDocumentModels"> Details regarding custom document models. </param>
        /// <returns> A new <see cref="DocumentIntelligence.ResourceDetails"/> instance for mocking. </returns>
        public static ResourceDetails ResourceDetails(CustomDocumentModelsDetails customDocumentModels = null)
        {
            return new ResourceDetails(customDocumentModels, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.CustomDocumentModelsDetails"/>. </summary>
        /// <param name="count"> Number of custom document models in the current resource. </param>
        /// <param name="limit"> Maximum number of custom document models supported in the current resource. </param>
        /// <returns> A new <see cref="DocumentIntelligence.CustomDocumentModelsDetails"/> instance for mocking. </returns>
        public static CustomDocumentModelsDetails CustomDocumentModelsDetails(int count = default, int limit = default)
        {
            return new CustomDocumentModelsDetails(count, limit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.BuildDocumentClassifierContent"/>. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="description"> Document classifier description. </param>
        /// <param name="baseClassifierId"> Base classifierId on top of which to train the classifier. </param>
        /// <param name="docTypes"> List of document types to classify against. </param>
        /// <param name="allowOverwrite"> Allow overwriting an existing classifier with the same name. </param>
        /// <returns> A new <see cref="DocumentIntelligence.BuildDocumentClassifierContent"/> instance for mocking. </returns>
        public static BuildDocumentClassifierContent BuildDocumentClassifierContent(string classifierId = null, string description = null, string baseClassifierId = null, IDictionary<string, ClassifierDocumentTypeDetails> docTypes = null, bool? allowOverwrite = null)
        {
            docTypes ??= new Dictionary<string, ClassifierDocumentTypeDetails>();

            return new BuildDocumentClassifierContent(
                classifierId,
                description,
                baseClassifierId,
                docTypes,
                allowOverwrite,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DocumentIntelligence.AuthorizeClassifierCopyContent"/>. </summary>
        /// <param name="classifierId"> Unique document classifier name. </param>
        /// <param name="description"> Document classifier description. </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document classifier. </param>
        /// <returns> A new <see cref="DocumentIntelligence.AuthorizeClassifierCopyContent"/> instance for mocking. </returns>
        public static AuthorizeClassifierCopyContent AuthorizeClassifierCopyContent(string classifierId = null, string description = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AuthorizeClassifierCopyContent(classifierId, description, tags, serializedAdditionalRawData: null);
        }
    }
}
