// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Client options for Azure.AI.DocumentIntelligence library clients. </summary>
    public partial class DocumentIntelligenceClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2024_07_31_Preview;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2024-07-31-preview". </summary>
            V2024_07_31_Preview = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of DocumentIntelligenceClientOptions. </summary>
        public DocumentIntelligenceClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2024_07_31_Preview => "2024-07-31-preview",
                _ => throw new NotSupportedException()
            };
        }
    }
}
