// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Currency field value. </summary>
    public partial class CurrencyValue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CurrencyValue"/>. </summary>
        /// <param name="amount"> Currency amount. </param>
        internal CurrencyValue(double amount)
        {
            Amount = amount;
        }

        /// <summary> Initializes a new instance of <see cref="CurrencyValue"/>. </summary>
        /// <param name="amount"> Currency amount. </param>
        /// <param name="currencySymbol"> Currency symbol label, if any. </param>
        /// <param name="currencyCode"> Resolved currency code (ISO 4217), if any. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CurrencyValue(double amount, string currencySymbol, string currencyCode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Amount = amount;
            CurrencySymbol = currencySymbol;
            CurrencyCode = currencyCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CurrencyValue"/> for deserialization. </summary>
        internal CurrencyValue()
        {
        }

        /// <summary> Currency amount. </summary>
        public double Amount { get; }
        /// <summary> Currency symbol label, if any. </summary>
        public string CurrencySymbol { get; }
        /// <summary> Resolved currency code (ISO 4217), if any. </summary>
        public string CurrencyCode { get; }
    }
}
