// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary>
    /// Authorization to copy a document model to the specified target resource and
    /// modelId.
    /// </summary>
    public partial class CopyAuthorization
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CopyAuthorization"/>. </summary>
        /// <param name="targetResourceId"> ID of the target Azure resource where the document model should be copied to. </param>
        /// <param name="targetResourceRegion">
        /// Location of the target Azure resource where the document model should be copied
        /// to.
        /// </param>
        /// <param name="targetModelId"> Identifier of the target document model. </param>
        /// <param name="targetModelLocation"> URL of the copied document model in the target account. </param>
        /// <param name="accessToken"> Token used to authorize the request. </param>
        /// <param name="expirationDateTime"> Date/time when the access token expires. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="targetResourceId"/>, <paramref name="targetResourceRegion"/>, <paramref name="targetModelId"/>, <paramref name="targetModelLocation"/> or <paramref name="accessToken"/> is null. </exception>
        public CopyAuthorization(string targetResourceId, string targetResourceRegion, string targetModelId, Uri targetModelLocation, string accessToken, DateTimeOffset expirationDateTime)
        {
            Argument.AssertNotNull(targetResourceId, nameof(targetResourceId));
            Argument.AssertNotNull(targetResourceRegion, nameof(targetResourceRegion));
            Argument.AssertNotNull(targetModelId, nameof(targetModelId));
            Argument.AssertNotNull(targetModelLocation, nameof(targetModelLocation));
            Argument.AssertNotNull(accessToken, nameof(accessToken));

            TargetResourceId = targetResourceId;
            TargetResourceRegion = targetResourceRegion;
            TargetModelId = targetModelId;
            TargetModelLocation = targetModelLocation;
            AccessToken = accessToken;
            ExpirationDateTime = expirationDateTime;
        }

        /// <summary> Initializes a new instance of <see cref="CopyAuthorization"/>. </summary>
        /// <param name="targetResourceId"> ID of the target Azure resource where the document model should be copied to. </param>
        /// <param name="targetResourceRegion">
        /// Location of the target Azure resource where the document model should be copied
        /// to.
        /// </param>
        /// <param name="targetModelId"> Identifier of the target document model. </param>
        /// <param name="targetModelLocation"> URL of the copied document model in the target account. </param>
        /// <param name="accessToken"> Token used to authorize the request. </param>
        /// <param name="expirationDateTime"> Date/time when the access token expires. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CopyAuthorization(string targetResourceId, string targetResourceRegion, string targetModelId, Uri targetModelLocation, string accessToken, DateTimeOffset expirationDateTime, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetResourceId = targetResourceId;
            TargetResourceRegion = targetResourceRegion;
            TargetModelId = targetModelId;
            TargetModelLocation = targetModelLocation;
            AccessToken = accessToken;
            ExpirationDateTime = expirationDateTime;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CopyAuthorization"/> for deserialization. </summary>
        internal CopyAuthorization()
        {
        }

        /// <summary> ID of the target Azure resource where the document model should be copied to. </summary>
        public string TargetResourceId { get; set; }
        /// <summary>
        /// Location of the target Azure resource where the document model should be copied
        /// to.
        /// </summary>
        public string TargetResourceRegion { get; set; }
        /// <summary> Identifier of the target document model. </summary>
        public string TargetModelId { get; set; }
        /// <summary> URL of the copied document model in the target account. </summary>
        public Uri TargetModelLocation { get; set; }
        /// <summary> Token used to authorize the request. </summary>
        public string AccessToken { get; set; }
        /// <summary> Date/time when the access token expires. </summary>
        public DateTimeOffset ExpirationDateTime { get; set; }
    }
}
