// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Type of content source. </summary>
    public readonly partial struct ContentSourceKind : IEquatable<ContentSourceKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContentSourceKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContentSourceKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UrlValue = "url";
        private const string Base64Value = "base64";
        private const string AzureBlobValue = "azureBlob";
        private const string AzureBlobFileListValue = "azureBlobFileList";

        /// <summary> Content at a specific URL. </summary>
        public static ContentSourceKind Url { get; } = new ContentSourceKind(UrlValue);
        /// <summary> Content represented via Base64 encoding. </summary>
        public static ContentSourceKind Base64 { get; } = new ContentSourceKind(Base64Value);
        /// <summary> Files in a path within an Azure Blob Storage container. </summary>
        public static ContentSourceKind AzureBlob { get; } = new ContentSourceKind(AzureBlobValue);
        /// <summary> A file list specifying individual files in an Azure Blob Storage container. </summary>
        public static ContentSourceKind AzureBlobFileList { get; } = new ContentSourceKind(AzureBlobFileListValue);
        /// <summary> Determines if two <see cref="ContentSourceKind"/> values are the same. </summary>
        public static bool operator ==(ContentSourceKind left, ContentSourceKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContentSourceKind"/> values are not the same. </summary>
        public static bool operator !=(ContentSourceKind left, ContentSourceKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContentSourceKind"/>. </summary>
        public static implicit operator ContentSourceKind(string value) => new ContentSourceKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContentSourceKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContentSourceKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
