// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Format of the content in analyzed result. </summary>
    public readonly partial struct ContentFormat : IEquatable<ContentFormat>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContentFormat"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContentFormat(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TextValue = "text";
        private const string MarkdownValue = "markdown";

        /// <summary> Plain text representation of the document content without any formatting. </summary>
        public static ContentFormat Text { get; } = new ContentFormat(TextValue);
        /// <summary>
        /// Markdown representation of the document content with section headings, tables,
        /// etc.
        /// </summary>
        public static ContentFormat Markdown { get; } = new ContentFormat(MarkdownValue);
        /// <summary> Determines if two <see cref="ContentFormat"/> values are the same. </summary>
        public static bool operator ==(ContentFormat left, ContentFormat right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContentFormat"/> values are not the same. </summary>
        public static bool operator !=(ContentFormat left, ContentFormat right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContentFormat"/>. </summary>
        public static implicit operator ContentFormat(string value) => new ContentFormat(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContentFormat other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContentFormat other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
