// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary>
    /// Authorization to copy a document classifier to the specified target resource and
    /// classifierId.
    /// </summary>
    public partial class ClassifierCopyAuthorization
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClassifierCopyAuthorization"/>. </summary>
        /// <param name="targetResourceId"> ID of the target Azure resource where the document classifier should be copied to. </param>
        /// <param name="targetResourceRegion">
        /// Location of the target Azure resource where the document classifier should be copied
        /// to.
        /// </param>
        /// <param name="targetClassifierId"> Identifier of the target document classifier. </param>
        /// <param name="targetClassifierLocation"> URL of the copied document classifier in the target account. </param>
        /// <param name="accessToken"> Token used to authorize the request. </param>
        /// <param name="expirationDateTime"> Date/time when the access token expires. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="targetResourceId"/>, <paramref name="targetResourceRegion"/>, <paramref name="targetClassifierId"/>, <paramref name="targetClassifierLocation"/> or <paramref name="accessToken"/> is null. </exception>
        public ClassifierCopyAuthorization(string targetResourceId, string targetResourceRegion, string targetClassifierId, Uri targetClassifierLocation, string accessToken, DateTimeOffset expirationDateTime)
        {
            Argument.AssertNotNull(targetResourceId, nameof(targetResourceId));
            Argument.AssertNotNull(targetResourceRegion, nameof(targetResourceRegion));
            Argument.AssertNotNull(targetClassifierId, nameof(targetClassifierId));
            Argument.AssertNotNull(targetClassifierLocation, nameof(targetClassifierLocation));
            Argument.AssertNotNull(accessToken, nameof(accessToken));

            TargetResourceId = targetResourceId;
            TargetResourceRegion = targetResourceRegion;
            TargetClassifierId = targetClassifierId;
            TargetClassifierLocation = targetClassifierLocation;
            AccessToken = accessToken;
            ExpirationDateTime = expirationDateTime;
        }

        /// <summary> Initializes a new instance of <see cref="ClassifierCopyAuthorization"/>. </summary>
        /// <param name="targetResourceId"> ID of the target Azure resource where the document classifier should be copied to. </param>
        /// <param name="targetResourceRegion">
        /// Location of the target Azure resource where the document classifier should be copied
        /// to.
        /// </param>
        /// <param name="targetClassifierId"> Identifier of the target document classifier. </param>
        /// <param name="targetClassifierLocation"> URL of the copied document classifier in the target account. </param>
        /// <param name="accessToken"> Token used to authorize the request. </param>
        /// <param name="expirationDateTime"> Date/time when the access token expires. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClassifierCopyAuthorization(string targetResourceId, string targetResourceRegion, string targetClassifierId, Uri targetClassifierLocation, string accessToken, DateTimeOffset expirationDateTime, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TargetResourceId = targetResourceId;
            TargetResourceRegion = targetResourceRegion;
            TargetClassifierId = targetClassifierId;
            TargetClassifierLocation = targetClassifierLocation;
            AccessToken = accessToken;
            ExpirationDateTime = expirationDateTime;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClassifierCopyAuthorization"/> for deserialization. </summary>
        internal ClassifierCopyAuthorization()
        {
        }

        /// <summary> ID of the target Azure resource where the document classifier should be copied to. </summary>
        public string TargetResourceId { get; set; }
        /// <summary>
        /// Location of the target Azure resource where the document classifier should be copied
        /// to.
        /// </summary>
        public string TargetResourceRegion { get; set; }
        /// <summary> Identifier of the target document classifier. </summary>
        public string TargetClassifierId { get; set; }
        /// <summary> URL of the copied document classifier in the target account. </summary>
        public Uri TargetClassifierLocation { get; set; }
        /// <summary> Token used to authorize the request. </summary>
        public string AccessToken { get; set; }
        /// <summary> Date/time when the access token expires. </summary>
        public DateTimeOffset ExpirationDateTime { get; set; }
    }
}
