// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Request body to build a new custom document model. </summary>
    public partial class BuildDocumentModelContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BuildDocumentModelContent"/>. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="buildMode"> Custom document model build mode. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modelId"/> is null. </exception>
        public BuildDocumentModelContent(string modelId, DocumentBuildMode buildMode)
        {
            Argument.AssertNotNull(modelId, nameof(modelId));

            ModelId = modelId;
            BuildMode = buildMode;
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="BuildDocumentModelContent"/>. </summary>
        /// <param name="modelId"> Unique document model name. </param>
        /// <param name="description"> Document model description. </param>
        /// <param name="buildMode"> Custom document model build mode. </param>
        /// <param name="azureBlobSource">
        /// Azure Blob Storage location containing the training data.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </param>
        /// <param name="azureBlobFileListSource">
        /// Azure Blob Storage file list specifying the training data.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </param>
        /// <param name="tags"> List of key-value tag attributes associated with the document model. </param>
        /// <param name="maxTrainingHours"> Max number of V100-equivalent GPU hours to use for model training.  Default=0.5. </param>
        /// <param name="allowOverwrite"> Allow overwriting an existing model with the same name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BuildDocumentModelContent(string modelId, string description, DocumentBuildMode buildMode, AzureBlobContentSource azureBlobSource, AzureBlobFileListContentSource azureBlobFileListSource, IDictionary<string, string> tags, float? maxTrainingHours, bool? allowOverwrite, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ModelId = modelId;
            Description = description;
            BuildMode = buildMode;
            AzureBlobSource = azureBlobSource;
            AzureBlobFileListSource = azureBlobFileListSource;
            Tags = tags;
            MaxTrainingHours = maxTrainingHours;
            AllowOverwrite = allowOverwrite;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BuildDocumentModelContent"/> for deserialization. </summary>
        internal BuildDocumentModelContent()
        {
        }

        /// <summary> Unique document model name. </summary>
        public string ModelId { get; }
        /// <summary> Document model description. </summary>
        public string Description { get; set; }
        /// <summary> Custom document model build mode. </summary>
        public DocumentBuildMode BuildMode { get; }
        /// <summary>
        /// Azure Blob Storage location containing the training data.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </summary>
        public AzureBlobContentSource AzureBlobSource { get; set; }
        /// <summary>
        /// Azure Blob Storage file list specifying the training data.  Either
        /// azureBlobSource or azureBlobFileListSource must be specified.
        /// </summary>
        public AzureBlobFileListContentSource AzureBlobFileListSource { get; set; }
        /// <summary> List of key-value tag attributes associated with the document model. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> Max number of V100-equivalent GPU hours to use for model training.  Default=0.5. </summary>
        public float? MaxTrainingHours { get; set; }
        /// <summary> Allow overwriting an existing model with the same name. </summary>
        public bool? AllowOverwrite { get; set; }
    }
}
