// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Additional output to generate during analysis. </summary>
    public readonly partial struct AnalyzeOutputOption : IEquatable<AnalyzeOutputOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalyzeOutputOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalyzeOutputOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PdfValue = "pdf";
        private const string FiguresValue = "figures";

        /// <summary> Generate searchable PDF output. </summary>
        public static AnalyzeOutputOption Pdf { get; } = new AnalyzeOutputOption(PdfValue);
        /// <summary> Generate cropped images of detected figures. </summary>
        public static AnalyzeOutputOption Figures { get; } = new AnalyzeOutputOption(FiguresValue);
        /// <summary> Determines if two <see cref="AnalyzeOutputOption"/> values are the same. </summary>
        public static bool operator ==(AnalyzeOutputOption left, AnalyzeOutputOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalyzeOutputOption"/> values are not the same. </summary>
        public static bool operator !=(AnalyzeOutputOption left, AnalyzeOutputOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalyzeOutputOption"/>. </summary>
        public static implicit operator AnalyzeOutputOption(string value) => new AnalyzeOutputOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalyzeOutputOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalyzeOutputOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
