// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Batch document analysis result. </summary>
    public partial class AnalyzeBatchResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnalyzeBatchResult"/>. </summary>
        /// <param name="succeededCount"> Number of documents that completed with status succeeded. </param>
        /// <param name="failedCount"> Number of documents that completed with status failed. </param>
        /// <param name="skippedCount"> Number of documents that completed with status skipped. </param>
        /// <param name="details"> Operation detail for each document in the batch. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="details"/> is null. </exception>
        internal AnalyzeBatchResult(int succeededCount, int failedCount, int skippedCount, IEnumerable<AnalyzeBatchOperationDetail> details)
        {
            Argument.AssertNotNull(details, nameof(details));

            SucceededCount = succeededCount;
            FailedCount = failedCount;
            SkippedCount = skippedCount;
            Details = details.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeBatchResult"/>. </summary>
        /// <param name="succeededCount"> Number of documents that completed with status succeeded. </param>
        /// <param name="failedCount"> Number of documents that completed with status failed. </param>
        /// <param name="skippedCount"> Number of documents that completed with status skipped. </param>
        /// <param name="details"> Operation detail for each document in the batch. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnalyzeBatchResult(int succeededCount, int failedCount, int skippedCount, IReadOnlyList<AnalyzeBatchOperationDetail> details, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SucceededCount = succeededCount;
            FailedCount = failedCount;
            SkippedCount = skippedCount;
            Details = details;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeBatchResult"/> for deserialization. </summary>
        internal AnalyzeBatchResult()
        {
        }

        /// <summary> Number of documents that completed with status succeeded. </summary>
        public int SucceededCount { get; }
        /// <summary> Number of documents that completed with status failed. </summary>
        public int FailedCount { get; }
        /// <summary> Number of documents that completed with status skipped. </summary>
        public int SkippedCount { get; }
        /// <summary> Operation detail for each document in the batch. </summary>
        public IReadOnlyList<AnalyzeBatchOperationDetail> Details { get; }
    }
}
