// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Operation detail for a document in a batch analysis. </summary>
    public partial class AnalyzeBatchOperationDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnalyzeBatchOperationDetail"/>. </summary>
        /// <param name="status"> Analyze status.  succeeded, failed, or skipped. </param>
        /// <param name="sourceUrl"> URL of the source document. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourceUrl"/> is null. </exception>
        internal AnalyzeBatchOperationDetail(OperationStatus status, Uri sourceUrl)
        {
            Argument.AssertNotNull(sourceUrl, nameof(sourceUrl));

            Status = status;
            SourceUrl = sourceUrl;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeBatchOperationDetail"/>. </summary>
        /// <param name="status"> Analyze status.  succeeded, failed, or skipped. </param>
        /// <param name="sourceUrl"> URL of the source document. </param>
        /// <param name="resultUrl"> URL of the analyze result JSON. </param>
        /// <param name="error"> Encountered error. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnalyzeBatchOperationDetail(OperationStatus status, Uri sourceUrl, Uri resultUrl, DocumentIntelligenceError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            SourceUrl = sourceUrl;
            ResultUrl = resultUrl;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AnalyzeBatchOperationDetail"/> for deserialization. </summary>
        internal AnalyzeBatchOperationDetail()
        {
        }

        /// <summary> Analyze status.  succeeded, failed, or skipped. </summary>
        public OperationStatus Status { get; }
        /// <summary> URL of the source document. </summary>
        public Uri SourceUrl { get; }
        /// <summary> URL of the analyze result JSON. </summary>
        public Uri ResultUrl { get; }
        /// <summary> Encountered error. </summary>
        public DocumentIntelligenceError Error { get; }
    }
}
