// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.DocumentIntelligence
{
    /// <summary> Address field value. </summary>
    public partial class AddressValue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AddressValue"/>. </summary>
        internal AddressValue()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AddressValue"/>. </summary>
        /// <param name="houseNumber"> House or building number. </param>
        /// <param name="poBox"> Post office box number. </param>
        /// <param name="road"> Street name. </param>
        /// <param name="city"> Name of city, town, village, etc. </param>
        /// <param name="state"> First-level administrative division. </param>
        /// <param name="postalCode"> Postal code used for mail sorting. </param>
        /// <param name="countryRegion"> Country/region. </param>
        /// <param name="streetAddress"> Street-level address, excluding city, state, countryRegion, and postalCode. </param>
        /// <param name="unit"> Apartment or office number. </param>
        /// <param name="cityDistrict">
        /// Districts or boroughs within a city, such as Brooklyn in New York City or City
        /// of Westminster in London.
        /// </param>
        /// <param name="stateDistrict"> Second-level administrative division used in certain locales. </param>
        /// <param name="suburb"> Unofficial neighborhood name, like Chinatown. </param>
        /// <param name="house"> Build name, such as World Trade Center. </param>
        /// <param name="level"> Floor number, such as 3F. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AddressValue(string houseNumber, string poBox, string road, string city, string state, string postalCode, string countryRegion, string streetAddress, string unit, string cityDistrict, string stateDistrict, string suburb, string house, string level, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            HouseNumber = houseNumber;
            PoBox = poBox;
            Road = road;
            City = city;
            State = state;
            PostalCode = postalCode;
            CountryRegion = countryRegion;
            StreetAddress = streetAddress;
            Unit = unit;
            CityDistrict = cityDistrict;
            StateDistrict = stateDistrict;
            Suburb = suburb;
            House = house;
            Level = level;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> House or building number. </summary>
        public string HouseNumber { get; }
        /// <summary> Post office box number. </summary>
        public string PoBox { get; }
        /// <summary> Street name. </summary>
        public string Road { get; }
        /// <summary> Name of city, town, village, etc. </summary>
        public string City { get; }
        /// <summary> First-level administrative division. </summary>
        public string State { get; }
        /// <summary> Postal code used for mail sorting. </summary>
        public string PostalCode { get; }
        /// <summary> Country/region. </summary>
        public string CountryRegion { get; }
        /// <summary> Street-level address, excluding city, state, countryRegion, and postalCode. </summary>
        public string StreetAddress { get; }
        /// <summary> Apartment or office number. </summary>
        public string Unit { get; }
        /// <summary>
        /// Districts or boroughs within a city, such as Brooklyn in New York City or City
        /// of Westminster in London.
        /// </summary>
        public string CityDistrict { get; }
        /// <summary> Second-level administrative division used in certain locales. </summary>
        public string StateDistrict { get; }
        /// <summary> Unofficial neighborhood name, like Chinatown. </summary>
        public string Suburb { get; }
        /// <summary> Build name, such as World Trade Center. </summary>
        public string House { get; }
        /// <summary> Floor number, such as 3F. </summary>
        public string Level { get; }
    }
}
