// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;

namespace Azure.ResourceManager.DnsResolver.Models
{
    /// <summary> Describes a server to forward the DNS queries to. </summary>
    public partial class TargetDnsServer
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TargetDnsServer"/>. </summary>
        /// <param name="ipAddress"> DNS server IP address. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ipAddress"/> is null. </exception>
        public TargetDnsServer(IPAddress ipAddress)
        {
            Argument.AssertNotNull(ipAddress, nameof(ipAddress));

            IPAddress = ipAddress;
        }

        /// <summary> Initializes a new instance of <see cref="TargetDnsServer"/>. </summary>
        /// <param name="ipAddress"> DNS server IP address. </param>
        /// <param name="port"> DNS server port. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TargetDnsServer(IPAddress ipAddress, int? port, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IPAddress = ipAddress;
            Port = port;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TargetDnsServer"/> for deserialization. </summary>
        internal TargetDnsServer()
        {
        }

        /// <summary> DNS server IP address. </summary>
        public IPAddress IPAddress { get; set; }
        /// <summary> DNS server port. </summary>
        public int? Port { get; set; }
    }
}
