// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DnsResolver.Models
{
    /// <summary> The state of DNS security rule. </summary>
    public readonly partial struct DnsSecurityRuleState : IEquatable<DnsSecurityRuleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DnsSecurityRuleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DnsSecurityRuleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DnsSecurityRuleState Enabled { get; } = new DnsSecurityRuleState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DnsSecurityRuleState Disabled { get; } = new DnsSecurityRuleState(DisabledValue);
        /// <summary> Determines if two <see cref="DnsSecurityRuleState"/> values are the same. </summary>
        public static bool operator ==(DnsSecurityRuleState left, DnsSecurityRuleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DnsSecurityRuleState"/> values are not the same. </summary>
        public static bool operator !=(DnsSecurityRuleState left, DnsSecurityRuleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DnsSecurityRuleState"/>. </summary>
        public static implicit operator DnsSecurityRuleState(string value) => new DnsSecurityRuleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DnsSecurityRuleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DnsSecurityRuleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
