// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DnsResolver.Models
{
    /// <summary> The type of action to take. </summary>
    public readonly partial struct DnsSecurityRuleActionType : IEquatable<DnsSecurityRuleActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DnsSecurityRuleActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DnsSecurityRuleActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string AlertValue = "Alert";
        private const string BlockValue = "Block";

        /// <summary> Allow. </summary>
        public static DnsSecurityRuleActionType Allow { get; } = new DnsSecurityRuleActionType(AllowValue);
        /// <summary> Alert. </summary>
        public static DnsSecurityRuleActionType Alert { get; } = new DnsSecurityRuleActionType(AlertValue);
        /// <summary> Block. </summary>
        public static DnsSecurityRuleActionType Block { get; } = new DnsSecurityRuleActionType(BlockValue);
        /// <summary> Determines if two <see cref="DnsSecurityRuleActionType"/> values are the same. </summary>
        public static bool operator ==(DnsSecurityRuleActionType left, DnsSecurityRuleActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DnsSecurityRuleActionType"/> values are not the same. </summary>
        public static bool operator !=(DnsSecurityRuleActionType left, DnsSecurityRuleActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DnsSecurityRuleActionType"/>. </summary>
        public static implicit operator DnsSecurityRuleActionType(string value) => new DnsSecurityRuleActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DnsSecurityRuleActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DnsSecurityRuleActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
