// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DnsResolver.Models
{
    /// <summary> The current status of the DNS resolver. This is a read-only property and any attempt to set this value will be ignored. </summary>
    public readonly partial struct DnsResolverState : IEquatable<DnsResolverState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DnsResolverState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DnsResolverState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConnectedValue = "Connected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Connected. </summary>
        public static DnsResolverState Connected { get; } = new DnsResolverState(ConnectedValue);
        /// <summary> Disconnected. </summary>
        public static DnsResolverState Disconnected { get; } = new DnsResolverState(DisconnectedValue);
        /// <summary> Determines if two <see cref="DnsResolverState"/> values are the same. </summary>
        public static bool operator ==(DnsResolverState left, DnsResolverState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DnsResolverState"/> values are not the same. </summary>
        public static bool operator !=(DnsResolverState left, DnsResolverState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DnsResolverState"/>. </summary>
        public static implicit operator DnsResolverState(string value) => new DnsResolverState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DnsResolverState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DnsResolverState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
