// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DnsResolver.Models
{
    /// <summary> Describes a DNS resolver domain list for PATCH operation. </summary>
    public partial class DnsResolverDomainListPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DnsResolverDomainListPatch"/>. </summary>
        public DnsResolverDomainListPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            Domains = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DnsResolverDomainListPatch"/>. </summary>
        /// <param name="tags"> Tags for DNS resolver domain list. </param>
        /// <param name="domains"> The domains in the domain list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DnsResolverDomainListPatch(IDictionary<string, string> tags, IList<string> domains, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            Domains = domains;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Tags for DNS resolver domain list. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> The domains in the domain list. </summary>
        public IList<string> Domains { get; }
    }
}
