// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DnsResolver.Models
{
    /// <summary> The state of forwarding rule. </summary>
    public readonly partial struct DnsForwardingRuleState : IEquatable<DnsForwardingRuleState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DnsForwardingRuleState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DnsForwardingRuleState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DnsForwardingRuleState Enabled { get; } = new DnsForwardingRuleState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DnsForwardingRuleState Disabled { get; } = new DnsForwardingRuleState(DisabledValue);
        /// <summary> Determines if two <see cref="DnsForwardingRuleState"/> values are the same. </summary>
        public static bool operator ==(DnsForwardingRuleState left, DnsForwardingRuleState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DnsForwardingRuleState"/> values are not the same. </summary>
        public static bool operator !=(DnsForwardingRuleState left, DnsForwardingRuleState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DnsForwardingRuleState"/>. </summary>
        public static implicit operator DnsForwardingRuleState(string value) => new DnsForwardingRuleState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DnsForwardingRuleState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DnsForwardingRuleState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
