// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DnsResolver
{
    internal class DnsResolverPolicyOperationSource : IOperationSource<DnsResolverPolicyResource>
    {
        private readonly ArmClient _client;

        internal DnsResolverPolicyOperationSource(ArmClient client)
        {
            _client = client;
        }

        DnsResolverPolicyResource IOperationSource<DnsResolverPolicyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DnsResolverPolicyData.DeserializeDnsResolverPolicyData(document.RootElement);
            return new DnsResolverPolicyResource(_client, data);
        }

        async ValueTask<DnsResolverPolicyResource> IOperationSource<DnsResolverPolicyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DnsResolverPolicyData.DeserializeDnsResolverPolicyData(document.RootElement);
            return new DnsResolverPolicyResource(_client, data);
        }
    }
}
