// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DnsResolver
{
    internal class DnsResolverOperationSource : IOperationSource<DnsResolverResource>
    {
        private readonly ArmClient _client;

        internal DnsResolverOperationSource(ArmClient client)
        {
            _client = client;
        }

        DnsResolverResource IOperationSource<DnsResolverResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DnsResolverData.DeserializeDnsResolverData(document.RootElement);
            return new DnsResolverResource(_client, data);
        }

        async ValueTask<DnsResolverResource> IOperationSource<DnsResolverResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DnsResolverData.DeserializeDnsResolverData(document.RootElement);
            return new DnsResolverResource(_client, data);
        }
    }
}
