// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DnsResolver
{
    internal class DnsResolverDomainListOperationSource : IOperationSource<DnsResolverDomainListResource>
    {
        private readonly ArmClient _client;

        internal DnsResolverDomainListOperationSource(ArmClient client)
        {
            _client = client;
        }

        DnsResolverDomainListResource IOperationSource<DnsResolverDomainListResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DnsResolverDomainListData.DeserializeDnsResolverDomainListData(document.RootElement);
            return new DnsResolverDomainListResource(_client, data);
        }

        async ValueTask<DnsResolverDomainListResource> IOperationSource<DnsResolverDomainListResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DnsResolverDomainListData.DeserializeDnsResolverDomainListData(document.RootElement);
            return new DnsResolverDomainListResource(_client, data);
        }
    }
}
