// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DnsResolver
{
    internal class DnsForwardingRulesetOperationSource : IOperationSource<DnsForwardingRulesetResource>
    {
        private readonly ArmClient _client;

        internal DnsForwardingRulesetOperationSource(ArmClient client)
        {
            _client = client;
        }

        DnsForwardingRulesetResource IOperationSource<DnsForwardingRulesetResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DnsForwardingRulesetData.DeserializeDnsForwardingRulesetData(document.RootElement);
            return new DnsForwardingRulesetResource(_client, data);
        }

        async ValueTask<DnsForwardingRulesetResource> IOperationSource<DnsForwardingRulesetResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DnsForwardingRulesetData.DeserializeDnsForwardingRulesetData(document.RootElement);
            return new DnsForwardingRulesetResource(_client, data);
        }
    }
}
