// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DnsResolver.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableDnsResolverResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDnsResolverResourceGroupResource"/> class for mocking. </summary>
        protected MockableDnsResolverResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDnsResolverResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDnsResolverResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of DnsResolverResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of DnsResolverResources and their operations over a DnsResolverResource. </returns>
        public virtual DnsResolverCollection GetDnsResolvers()
        {
            return GetCachedClient(client => new DnsResolverCollection(client, Id));
        }

        /// <summary>
        /// Gets properties of a DNS resolver.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolvers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverName"> The name of the DNS resolver. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<DnsResolverResource>> GetDnsResolverAsync(string dnsResolverName, CancellationToken cancellationToken = default)
        {
            return await GetDnsResolvers().GetAsync(dnsResolverName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets properties of a DNS resolver.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolvers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverName"> The name of the DNS resolver. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<DnsResolverResource> GetDnsResolver(string dnsResolverName, CancellationToken cancellationToken = default)
        {
            return GetDnsResolvers().Get(dnsResolverName, cancellationToken);
        }

        /// <summary> Gets a collection of DnsForwardingRulesetResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of DnsForwardingRulesetResources and their operations over a DnsForwardingRulesetResource. </returns>
        public virtual DnsForwardingRulesetCollection GetDnsForwardingRulesets()
        {
            return GetCachedClient(client => new DnsForwardingRulesetCollection(client, Id));
        }

        /// <summary>
        /// Gets a DNS forwarding ruleset properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsForwardingRulesets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsForwardingRulesetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="rulesetName"> The name of the DNS forwarding ruleset. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="rulesetName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="rulesetName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<DnsForwardingRulesetResource>> GetDnsForwardingRulesetAsync(string rulesetName, CancellationToken cancellationToken = default)
        {
            return await GetDnsForwardingRulesets().GetAsync(rulesetName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a DNS forwarding ruleset properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsForwardingRulesets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsForwardingRulesetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="rulesetName"> The name of the DNS forwarding ruleset. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="rulesetName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="rulesetName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<DnsForwardingRulesetResource> GetDnsForwardingRuleset(string rulesetName, CancellationToken cancellationToken = default)
        {
            return GetDnsForwardingRulesets().Get(rulesetName, cancellationToken);
        }

        /// <summary> Gets a collection of DnsResolverPolicyResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of DnsResolverPolicyResources and their operations over a DnsResolverPolicyResource. </returns>
        public virtual DnsResolverPolicyCollection GetDnsResolverPolicies()
        {
            return GetCachedClient(client => new DnsResolverPolicyCollection(client, Id));
        }

        /// <summary>
        /// Gets properties of a DNS resolver policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverPolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverPolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverPolicyName"> The name of the DNS resolver policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverPolicyName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverPolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<DnsResolverPolicyResource>> GetDnsResolverPolicyAsync(string dnsResolverPolicyName, CancellationToken cancellationToken = default)
        {
            return await GetDnsResolverPolicies().GetAsync(dnsResolverPolicyName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets properties of a DNS resolver policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverPolicies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverPolicyResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverPolicyName"> The name of the DNS resolver policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverPolicyName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverPolicyName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<DnsResolverPolicyResource> GetDnsResolverPolicy(string dnsResolverPolicyName, CancellationToken cancellationToken = default)
        {
            return GetDnsResolverPolicies().Get(dnsResolverPolicyName, cancellationToken);
        }

        /// <summary> Gets a collection of DnsResolverDomainListResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of DnsResolverDomainListResources and their operations over a DnsResolverDomainListResource. </returns>
        public virtual DnsResolverDomainListCollection GetDnsResolverDomainLists()
        {
            return GetCachedClient(client => new DnsResolverDomainListCollection(client, Id));
        }

        /// <summary>
        /// Gets properties of a DNS resolver domain list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<DnsResolverDomainListResource>> GetDnsResolverDomainListAsync(string dnsResolverDomainListName, CancellationToken cancellationToken = default)
        {
            return await GetDnsResolverDomainLists().GetAsync(dnsResolverDomainListName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets properties of a DNS resolver domain list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<DnsResolverDomainListResource> GetDnsResolverDomainList(string dnsResolverDomainListName, CancellationToken cancellationToken = default)
        {
            return GetDnsResolverDomainLists().Get(dnsResolverDomainListName, cancellationToken);
        }
    }
}
