// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.DnsResolver.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.DnsResolver
{
    /// <summary>
    /// A class representing the DnsSecurityRule data model.
    /// Describes a DNS security rule.
    /// </summary>
    public partial class DnsSecurityRuleData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DnsSecurityRuleData"/>. </summary>
        /// <param name="location"> The location. </param>
        /// <param name="priority"> The priority of the DNS security rule. </param>
        /// <param name="action"> The action to take on DNS requests that match the DNS security rule. </param>
        /// <param name="dnsResolverDomainLists"> DNS resolver policy domains lists that the DNS security rule applies to. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="action"/> or <paramref name="dnsResolverDomainLists"/> is null. </exception>
        public DnsSecurityRuleData(AzureLocation location, int priority, DnsSecurityRuleAction action, IEnumerable<WritableSubResource> dnsResolverDomainLists) : base(location)
        {
            Argument.AssertNotNull(action, nameof(action));
            Argument.AssertNotNull(dnsResolverDomainLists, nameof(dnsResolverDomainLists));

            Priority = priority;
            Action = action;
            DnsResolverDomainLists = dnsResolverDomainLists.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="DnsSecurityRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> ETag of the DNS security rule. </param>
        /// <param name="priority"> The priority of the DNS security rule. </param>
        /// <param name="action"> The action to take on DNS requests that match the DNS security rule. </param>
        /// <param name="dnsResolverDomainLists"> DNS resolver policy domains lists that the DNS security rule applies to. </param>
        /// <param name="dnsSecurityRuleState"> The state of DNS security rule. </param>
        /// <param name="provisioningState"> The current provisioning state of the DNS security rule. This is a read-only property and any attempt to set this value will be ignored. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DnsSecurityRuleData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ETag? etag, int priority, DnsSecurityRuleAction action, IList<WritableSubResource> dnsResolverDomainLists, DnsSecurityRuleState? dnsSecurityRuleState, DnsResolverProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ETag = etag;
            Priority = priority;
            Action = action;
            DnsResolverDomainLists = dnsResolverDomainLists;
            DnsSecurityRuleState = dnsSecurityRuleState;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DnsSecurityRuleData"/> for deserialization. </summary>
        internal DnsSecurityRuleData()
        {
        }

        /// <summary> ETag of the DNS security rule. </summary>
        public ETag? ETag { get; }
        /// <summary> The priority of the DNS security rule. </summary>
        public int Priority { get; set; }
        /// <summary> The action to take on DNS requests that match the DNS security rule. </summary>
        public DnsSecurityRuleAction Action { get; set; }
        /// <summary> DNS resolver policy domains lists that the DNS security rule applies to. </summary>
        public IList<WritableSubResource> DnsResolverDomainLists { get; }
        /// <summary> The state of DNS security rule. </summary>
        public DnsSecurityRuleState? DnsSecurityRuleState { get; set; }
        /// <summary> The current provisioning state of the DNS security rule. This is a read-only property and any attempt to set this value will be ignored. </summary>
        public DnsResolverProvisioningState? ProvisioningState { get; }
    }
}
