// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.DnsResolver
{
    /// <summary>
    /// A class representing a collection of <see cref="DnsSecurityRuleResource"/> and their operations.
    /// Each <see cref="DnsSecurityRuleResource"/> in the collection will belong to the same instance of <see cref="DnsResolverPolicyResource"/>.
    /// To get a <see cref="DnsSecurityRuleCollection"/> instance call the GetDnsSecurityRules method from an instance of <see cref="DnsResolverPolicyResource"/>.
    /// </summary>
    public partial class DnsSecurityRuleCollection : ArmCollection, IEnumerable<DnsSecurityRuleResource>, IAsyncEnumerable<DnsSecurityRuleResource>
    {
        private readonly ClientDiagnostics _dnsSecurityRuleClientDiagnostics;
        private readonly DnsSecurityRulesRestOperations _dnsSecurityRuleRestClient;

        /// <summary> Initializes a new instance of the <see cref="DnsSecurityRuleCollection"/> class for mocking. </summary>
        protected DnsSecurityRuleCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DnsSecurityRuleCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DnsSecurityRuleCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _dnsSecurityRuleClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.DnsResolver", DnsSecurityRuleResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DnsSecurityRuleResource.ResourceType, out string dnsSecurityRuleApiVersion);
            _dnsSecurityRuleRestClient = new DnsSecurityRulesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, dnsSecurityRuleApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != DnsResolverPolicyResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, DnsResolverPolicyResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a DNS security rule for a DNS resolver policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules/{dnsSecurityRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="dnsSecurityRuleName"> The name of the DNS security rule. </param>
        /// <param name="data"> Parameters supplied to the CreateOrUpdate operation. </param>
        /// <param name="ifMatch"> ETag of the resource. Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent changes. </param>
        /// <param name="ifNoneMatch"> Set to '*' to allow a new resource to be created, but to prevent updating an existing resource. Other values will be ignored. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsSecurityRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsSecurityRuleName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<DnsSecurityRuleResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string dnsSecurityRuleName, DnsSecurityRuleData data, string ifMatch = null, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsSecurityRuleName, nameof(dnsSecurityRuleName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dnsSecurityRuleClientDiagnostics.CreateScope("DnsSecurityRuleCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _dnsSecurityRuleRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, data, ifMatch, ifNoneMatch, cancellationToken).ConfigureAwait(false);
                var operation = new DnsResolverArmOperation<DnsSecurityRuleResource>(new DnsSecurityRuleOperationSource(Client), _dnsSecurityRuleClientDiagnostics, Pipeline, _dnsSecurityRuleRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, data, ifMatch, ifNoneMatch).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a DNS security rule for a DNS resolver policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules/{dnsSecurityRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="dnsSecurityRuleName"> The name of the DNS security rule. </param>
        /// <param name="data"> Parameters supplied to the CreateOrUpdate operation. </param>
        /// <param name="ifMatch"> ETag of the resource. Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent changes. </param>
        /// <param name="ifNoneMatch"> Set to '*' to allow a new resource to be created, but to prevent updating an existing resource. Other values will be ignored. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsSecurityRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsSecurityRuleName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<DnsSecurityRuleResource> CreateOrUpdate(WaitUntil waitUntil, string dnsSecurityRuleName, DnsSecurityRuleData data, string ifMatch = null, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsSecurityRuleName, nameof(dnsSecurityRuleName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dnsSecurityRuleClientDiagnostics.CreateScope("DnsSecurityRuleCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _dnsSecurityRuleRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, data, ifMatch, ifNoneMatch, cancellationToken);
                var operation = new DnsResolverArmOperation<DnsSecurityRuleResource>(new DnsSecurityRuleOperationSource(Client), _dnsSecurityRuleClientDiagnostics, Pipeline, _dnsSecurityRuleRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, data, ifMatch, ifNoneMatch).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets properties of a DNS security rule for a DNS resolver policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules/{dnsSecurityRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsSecurityRuleName"> The name of the DNS security rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsSecurityRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsSecurityRuleName"/> is null. </exception>
        public virtual async Task<Response<DnsSecurityRuleResource>> GetAsync(string dnsSecurityRuleName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsSecurityRuleName, nameof(dnsSecurityRuleName));

            using var scope = _dnsSecurityRuleClientDiagnostics.CreateScope("DnsSecurityRuleCollection.Get");
            scope.Start();
            try
            {
                var response = await _dnsSecurityRuleRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DnsSecurityRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets properties of a DNS security rule for a DNS resolver policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules/{dnsSecurityRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsSecurityRuleName"> The name of the DNS security rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsSecurityRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsSecurityRuleName"/> is null. </exception>
        public virtual Response<DnsSecurityRuleResource> Get(string dnsSecurityRuleName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsSecurityRuleName, nameof(dnsSecurityRuleName));

            using var scope = _dnsSecurityRuleClientDiagnostics.CreateScope("DnsSecurityRuleCollection.Get");
            scope.Start();
            try
            {
                var response = _dnsSecurityRuleRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DnsSecurityRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists DNS security rules for a DNS resolver policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> The maximum number of results to return. If not specified, returns up to 100 results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DnsSecurityRuleResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DnsSecurityRuleResource> GetAllAsync(int? top = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dnsSecurityRuleRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, top);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dnsSecurityRuleRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, top);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DnsSecurityRuleResource(Client, DnsSecurityRuleData.DeserializeDnsSecurityRuleData(e)), _dnsSecurityRuleClientDiagnostics, Pipeline, "DnsSecurityRuleCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists DNS security rules for a DNS resolver policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> The maximum number of results to return. If not specified, returns up to 100 results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DnsSecurityRuleResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DnsSecurityRuleResource> GetAll(int? top = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dnsSecurityRuleRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, top);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dnsSecurityRuleRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, top);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DnsSecurityRuleResource(Client, DnsSecurityRuleData.DeserializeDnsSecurityRuleData(e)), _dnsSecurityRuleClientDiagnostics, Pipeline, "DnsSecurityRuleCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules/{dnsSecurityRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsSecurityRuleName"> The name of the DNS security rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsSecurityRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsSecurityRuleName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string dnsSecurityRuleName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsSecurityRuleName, nameof(dnsSecurityRuleName));

            using var scope = _dnsSecurityRuleClientDiagnostics.CreateScope("DnsSecurityRuleCollection.Exists");
            scope.Start();
            try
            {
                var response = await _dnsSecurityRuleRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules/{dnsSecurityRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsSecurityRuleName"> The name of the DNS security rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsSecurityRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsSecurityRuleName"/> is null. </exception>
        public virtual Response<bool> Exists(string dnsSecurityRuleName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsSecurityRuleName, nameof(dnsSecurityRuleName));

            using var scope = _dnsSecurityRuleClientDiagnostics.CreateScope("DnsSecurityRuleCollection.Exists");
            scope.Start();
            try
            {
                var response = _dnsSecurityRuleRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules/{dnsSecurityRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsSecurityRuleName"> The name of the DNS security rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsSecurityRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsSecurityRuleName"/> is null. </exception>
        public virtual async Task<NullableResponse<DnsSecurityRuleResource>> GetIfExistsAsync(string dnsSecurityRuleName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsSecurityRuleName, nameof(dnsSecurityRuleName));

            using var scope = _dnsSecurityRuleClientDiagnostics.CreateScope("DnsSecurityRuleCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _dnsSecurityRuleRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DnsSecurityRuleResource>(response.GetRawResponse());
                return Response.FromValue(new DnsSecurityRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverPolicies/{dnsResolverPolicyName}/dnsSecurityRules/{dnsSecurityRuleName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsSecurityRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsSecurityRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsSecurityRuleName"> The name of the DNS security rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsSecurityRuleName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsSecurityRuleName"/> is null. </exception>
        public virtual NullableResponse<DnsSecurityRuleResource> GetIfExists(string dnsSecurityRuleName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsSecurityRuleName, nameof(dnsSecurityRuleName));

            using var scope = _dnsSecurityRuleClientDiagnostics.CreateScope("DnsSecurityRuleCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _dnsSecurityRuleRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dnsSecurityRuleName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DnsSecurityRuleResource>(response.GetRawResponse());
                return Response.FromValue(new DnsSecurityRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<DnsSecurityRuleResource> IEnumerable<DnsSecurityRuleResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<DnsSecurityRuleResource> IAsyncEnumerable<DnsSecurityRuleResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
