// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.DnsResolver
{
    /// <summary>
    /// A class representing a collection of <see cref="DnsResolverDomainListResource"/> and their operations.
    /// Each <see cref="DnsResolverDomainListResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="DnsResolverDomainListCollection"/> instance call the GetDnsResolverDomainLists method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class DnsResolverDomainListCollection : ArmCollection, IEnumerable<DnsResolverDomainListResource>, IAsyncEnumerable<DnsResolverDomainListResource>
    {
        private readonly ClientDiagnostics _dnsResolverDomainListClientDiagnostics;
        private readonly DnsResolverDomainListsRestOperations _dnsResolverDomainListRestClient;

        /// <summary> Initializes a new instance of the <see cref="DnsResolverDomainListCollection"/> class for mocking. </summary>
        protected DnsResolverDomainListCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DnsResolverDomainListCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DnsResolverDomainListCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _dnsResolverDomainListClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.DnsResolver", DnsResolverDomainListResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DnsResolverDomainListResource.ResourceType, out string dnsResolverDomainListApiVersion);
            _dnsResolverDomainListRestClient = new DnsResolverDomainListsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, dnsResolverDomainListApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a DNS resolver domain list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="data"> Parameters supplied to the CreateOrUpdate operation. </param>
        /// <param name="ifMatch"> ETag of the resource. Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent changes. </param>
        /// <param name="ifNoneMatch"> Set to '*' to allow a new resource to be created, but to prevent updating an existing resource. Other values will be ignored. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<DnsResolverDomainListResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string dnsResolverDomainListName, DnsResolverDomainListData data, string ifMatch = null, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsResolverDomainListName, nameof(dnsResolverDomainListName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dnsResolverDomainListClientDiagnostics.CreateScope("DnsResolverDomainListCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _dnsResolverDomainListRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, data, ifMatch, ifNoneMatch, cancellationToken).ConfigureAwait(false);
                var operation = new DnsResolverArmOperation<DnsResolverDomainListResource>(new DnsResolverDomainListOperationSource(Client), _dnsResolverDomainListClientDiagnostics, Pipeline, _dnsResolverDomainListRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, data, ifMatch, ifNoneMatch).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a DNS resolver domain list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="data"> Parameters supplied to the CreateOrUpdate operation. </param>
        /// <param name="ifMatch"> ETag of the resource. Omit this value to always overwrite the current resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent changes. </param>
        /// <param name="ifNoneMatch"> Set to '*' to allow a new resource to be created, but to prevent updating an existing resource. Other values will be ignored. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<DnsResolverDomainListResource> CreateOrUpdate(WaitUntil waitUntil, string dnsResolverDomainListName, DnsResolverDomainListData data, string ifMatch = null, string ifNoneMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsResolverDomainListName, nameof(dnsResolverDomainListName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _dnsResolverDomainListClientDiagnostics.CreateScope("DnsResolverDomainListCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _dnsResolverDomainListRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, data, ifMatch, ifNoneMatch, cancellationToken);
                var operation = new DnsResolverArmOperation<DnsResolverDomainListResource>(new DnsResolverDomainListOperationSource(Client), _dnsResolverDomainListClientDiagnostics, Pipeline, _dnsResolverDomainListRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, data, ifMatch, ifNoneMatch).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets properties of a DNS resolver domain list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> is null. </exception>
        public virtual async Task<Response<DnsResolverDomainListResource>> GetAsync(string dnsResolverDomainListName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsResolverDomainListName, nameof(dnsResolverDomainListName));

            using var scope = _dnsResolverDomainListClientDiagnostics.CreateScope("DnsResolverDomainListCollection.Get");
            scope.Start();
            try
            {
                var response = await _dnsResolverDomainListRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DnsResolverDomainListResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets properties of a DNS resolver domain list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> is null. </exception>
        public virtual Response<DnsResolverDomainListResource> Get(string dnsResolverDomainListName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsResolverDomainListName, nameof(dnsResolverDomainListName));

            using var scope = _dnsResolverDomainListClientDiagnostics.CreateScope("DnsResolverDomainListCollection.Get");
            scope.Start();
            try
            {
                var response = _dnsResolverDomainListRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DnsResolverDomainListResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists DNS resolver domain lists within a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> The maximum number of results to return. If not specified, returns up to 100 results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DnsResolverDomainListResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DnsResolverDomainListResource> GetAllAsync(int? top = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dnsResolverDomainListRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName, top);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dnsResolverDomainListRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, top);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DnsResolverDomainListResource(Client, DnsResolverDomainListData.DeserializeDnsResolverDomainListData(e)), _dnsResolverDomainListClientDiagnostics, Pipeline, "DnsResolverDomainListCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists DNS resolver domain lists within a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> The maximum number of results to return. If not specified, returns up to 100 results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DnsResolverDomainListResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DnsResolverDomainListResource> GetAll(int? top = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _dnsResolverDomainListRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName, top);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _dnsResolverDomainListRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, top);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DnsResolverDomainListResource(Client, DnsResolverDomainListData.DeserializeDnsResolverDomainListData(e)), _dnsResolverDomainListClientDiagnostics, Pipeline, "DnsResolverDomainListCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string dnsResolverDomainListName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsResolverDomainListName, nameof(dnsResolverDomainListName));

            using var scope = _dnsResolverDomainListClientDiagnostics.CreateScope("DnsResolverDomainListCollection.Exists");
            scope.Start();
            try
            {
                var response = await _dnsResolverDomainListRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> is null. </exception>
        public virtual Response<bool> Exists(string dnsResolverDomainListName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsResolverDomainListName, nameof(dnsResolverDomainListName));

            using var scope = _dnsResolverDomainListClientDiagnostics.CreateScope("DnsResolverDomainListCollection.Exists");
            scope.Start();
            try
            {
                var response = _dnsResolverDomainListRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> is null. </exception>
        public virtual async Task<NullableResponse<DnsResolverDomainListResource>> GetIfExistsAsync(string dnsResolverDomainListName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsResolverDomainListName, nameof(dnsResolverDomainListName));

            using var scope = _dnsResolverDomainListClientDiagnostics.CreateScope("DnsResolverDomainListCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _dnsResolverDomainListRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DnsResolverDomainListResource>(response.GetRawResponse());
                return Response.FromValue(new DnsResolverDomainListResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolverDomainLists/{dnsResolverDomainListName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DnsResolverDomainLists_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-07-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DnsResolverDomainListResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dnsResolverDomainListName"> The name of the DNS resolver domain list. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dnsResolverDomainListName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dnsResolverDomainListName"/> is null. </exception>
        public virtual NullableResponse<DnsResolverDomainListResource> GetIfExists(string dnsResolverDomainListName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dnsResolverDomainListName, nameof(dnsResolverDomainListName));

            using var scope = _dnsResolverDomainListClientDiagnostics.CreateScope("DnsResolverDomainListCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _dnsResolverDomainListRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, dnsResolverDomainListName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DnsResolverDomainListResource>(response.GetRawResponse());
                return Response.FromValue(new DnsResolverDomainListResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<DnsResolverDomainListResource> IEnumerable<DnsResolverDomainListResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<DnsResolverDomainListResource> IAsyncEnumerable<DnsResolverDomainListResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
