// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Dns.Models
{
    internal static partial class DnsZoneTypeExtensions
    {
        public static string ToSerialString(this DnsZoneType value) => value switch
        {
            DnsZoneType.Public => "Public",
            DnsZoneType.Private => "Private",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DnsZoneType value.")
        };

        public static DnsZoneType ToDnsZoneType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Public")) return DnsZoneType.Public;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Private")) return DnsZoneType.Private;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DnsZoneType value.");
        }
    }
}
