// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Dns.Models
{
    /// <summary> An SRV record. </summary>
    public partial class DnsSrvRecordInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DnsSrvRecordInfo"/>. </summary>
        public DnsSrvRecordInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DnsSrvRecordInfo"/>. </summary>
        /// <param name="priority"> The priority value for this SRV record. </param>
        /// <param name="weight"> The weight value for this SRV record. </param>
        /// <param name="port"> The port value for this SRV record. </param>
        /// <param name="target"> The target domain name for this SRV record. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DnsSrvRecordInfo(int? priority, int? weight, int? port, string target, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Priority = priority;
            Weight = weight;
            Port = port;
            Target = target;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The priority value for this SRV record. </summary>
        public int? Priority { get; set; }
        /// <summary> The weight value for this SRV record. </summary>
        public int? Weight { get; set; }
        /// <summary> The port value for this SRV record. </summary>
        public int? Port { get; set; }
        /// <summary> The target domain name for this SRV record. </summary>
        public string Target { get; set; }
    }
}
