// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Dns.Models
{
    public partial class DnsSigningKey : IUtf8JsonSerializable, IJsonModel<DnsSigningKey>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DnsSigningKey>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DnsSigningKey>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DnsSigningKey>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DnsSigningKey)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsCollectionDefined(DelegationSignerInfo))
            {
                writer.WritePropertyName("delegationSignerInfo"u8);
                writer.WriteStartArray();
                foreach (var item in DelegationSignerInfo)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Flags))
            {
                writer.WritePropertyName("flags"u8);
                writer.WriteNumberValue(Flags.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(KeyTag))
            {
                writer.WritePropertyName("keyTag"u8);
                writer.WriteNumberValue(KeyTag.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Protocol))
            {
                writer.WritePropertyName("protocol"u8);
                writer.WriteNumberValue(Protocol.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PublicKey))
            {
                writer.WritePropertyName("publicKey"u8);
                writer.WriteStringValue(PublicKey);
            }
            if (options.Format != "W" && Optional.IsDefined(SecurityAlgorithmType))
            {
                writer.WritePropertyName("securityAlgorithmType"u8);
                writer.WriteNumberValue(SecurityAlgorithmType.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DnsSigningKey IJsonModel<DnsSigningKey>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DnsSigningKey>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DnsSigningKey)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDnsSigningKey(document.RootElement, options);
        }

        internal static DnsSigningKey DeserializeDnsSigningKey(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<DelegationSignerInfo> delegationSignerInfo = default;
            int? flags = default;
            int? keyTag = default;
            int? protocol = default;
            string publicKey = default;
            int? securityAlgorithmType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("delegationSignerInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DelegationSignerInfo> array = new List<DelegationSignerInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Models.DelegationSignerInfo.DeserializeDelegationSignerInfo(item, options));
                    }
                    delegationSignerInfo = array;
                    continue;
                }
                if (property.NameEquals("flags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    flags = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("keyTag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    keyTag = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("protocol"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    protocol = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("publicKey"u8))
                {
                    publicKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("securityAlgorithmType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    securityAlgorithmType = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DnsSigningKey(
                delegationSignerInfo ?? new ChangeTrackingList<DelegationSignerInfo>(),
                flags,
                keyTag,
                protocol,
                publicKey,
                securityAlgorithmType,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DnsSigningKey>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DnsSigningKey>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DnsSigningKey)} does not support writing '{options.Format}' format.");
            }
        }

        DnsSigningKey IPersistableModel<DnsSigningKey>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DnsSigningKey>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDnsSigningKey(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DnsSigningKey)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DnsSigningKey>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
