// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Dns.Models
{
    /// <summary> Represents the properties of the Dns Resource Reference Result. </summary>
    public partial class DnsResourceReferenceResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DnsResourceReferenceResult"/>. </summary>
        internal DnsResourceReferenceResult()
        {
            DnsResourceReferences = new ChangeTrackingList<DnsResourceReference>();
        }

        /// <summary> Initializes a new instance of <see cref="DnsResourceReferenceResult"/>. </summary>
        /// <param name="dnsResourceReferences"> The result of dns resource reference request. A list of dns resource references for each of the azure resource in the request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DnsResourceReferenceResult(IReadOnlyList<DnsResourceReference> dnsResourceReferences, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DnsResourceReferences = dnsResourceReferences;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The result of dns resource reference request. A list of dns resource references for each of the azure resource in the request. </summary>
        public IReadOnlyList<DnsResourceReference> DnsResourceReferences { get; }
    }
}
