// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Dns.Models
{
    /// <summary> A CAA record. </summary>
    public partial class DnsCaaRecordInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DnsCaaRecordInfo"/>. </summary>
        public DnsCaaRecordInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DnsCaaRecordInfo"/>. </summary>
        /// <param name="flags"> The flags for this CAA record as an integer between 0 and 255. </param>
        /// <param name="tag"> The tag for this CAA record. </param>
        /// <param name="value"> The value for this CAA record. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DnsCaaRecordInfo(int? flags, string tag, string value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Flags = flags;
            Tag = tag;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The flags for this CAA record as an integer between 0 and 255. </summary>
        public int? Flags { get; set; }
        /// <summary> The tag for this CAA record. </summary>
        public string Tag { get; set; }
        /// <summary> The value for this CAA record. </summary>
        public string Value { get; set; }
    }
}
