// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Dns.Models
{
    /// <summary> The delegation signer information. </summary>
    public partial class DelegationSignerInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DelegationSignerInfo"/>. </summary>
        internal DelegationSignerInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DelegationSignerInfo"/>. </summary>
        /// <param name="digestAlgorithmType"> The digest algorithm type represents the standard digest algorithm number used to construct the digest. See: https://www.iana.org/assignments/ds-rr-types/ds-rr-types.xhtml. </param>
        /// <param name="digestValue"> The digest value is a cryptographic hash value of the referenced DNSKEY Resource Record. </param>
        /// <param name="record"> The record represents a delegation signer (DS) record. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DelegationSignerInfo(int? digestAlgorithmType, string digestValue, string record, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DigestAlgorithmType = digestAlgorithmType;
            DigestValue = digestValue;
            Record = record;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The digest algorithm type represents the standard digest algorithm number used to construct the digest. See: https://www.iana.org/assignments/ds-rr-types/ds-rr-types.xhtml. </summary>
        public int? DigestAlgorithmType { get; }
        /// <summary> The digest value is a cryptographic hash value of the referenced DNSKEY Resource Record. </summary>
        public string DigestValue { get; }
        /// <summary> The record represents a delegation signer (DS) record. </summary>
        public string Record { get; }
    }
}
