// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Dns.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDnsArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDnsArmClient"/> class for mocking. </summary>
        protected MockableDnsArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDnsArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDnsArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDnsArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnssecConfigResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnssecConfigResource.CreateResourceIdentifier" /> to create a <see cref="DnssecConfigResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnssecConfigResource"/> object. </returns>
        public virtual DnssecConfigResource GetDnssecConfigResource(ResourceIdentifier id)
        {
            DnssecConfigResource.ValidateResourceId(id);
            return new DnssecConfigResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsARecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsARecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsARecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsARecordResource"/> object. </returns>
        public virtual DnsARecordResource GetDnsARecordResource(ResourceIdentifier id)
        {
            DnsARecordResource.ValidateResourceId(id);
            return new DnsARecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsAaaaRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsAaaaRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsAaaaRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsAaaaRecordResource"/> object. </returns>
        public virtual DnsAaaaRecordResource GetDnsAaaaRecordResource(ResourceIdentifier id)
        {
            DnsAaaaRecordResource.ValidateResourceId(id);
            return new DnsAaaaRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsCaaRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsCaaRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsCaaRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsCaaRecordResource"/> object. </returns>
        public virtual DnsCaaRecordResource GetDnsCaaRecordResource(ResourceIdentifier id)
        {
            DnsCaaRecordResource.ValidateResourceId(id);
            return new DnsCaaRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsCnameRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsCnameRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsCnameRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsCnameRecordResource"/> object. </returns>
        public virtual DnsCnameRecordResource GetDnsCnameRecordResource(ResourceIdentifier id)
        {
            DnsCnameRecordResource.ValidateResourceId(id);
            return new DnsCnameRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsMXRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsMXRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsMXRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsMXRecordResource"/> object. </returns>
        public virtual DnsMXRecordResource GetDnsMXRecordResource(ResourceIdentifier id)
        {
            DnsMXRecordResource.ValidateResourceId(id);
            return new DnsMXRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsNSRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsNSRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsNSRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsNSRecordResource"/> object. </returns>
        public virtual DnsNSRecordResource GetDnsNSRecordResource(ResourceIdentifier id)
        {
            DnsNSRecordResource.ValidateResourceId(id);
            return new DnsNSRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsPtrRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsPtrRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsPtrRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsPtrRecordResource"/> object. </returns>
        public virtual DnsPtrRecordResource GetDnsPtrRecordResource(ResourceIdentifier id)
        {
            DnsPtrRecordResource.ValidateResourceId(id);
            return new DnsPtrRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsSoaRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsSoaRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsSoaRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsSoaRecordResource"/> object. </returns>
        public virtual DnsSoaRecordResource GetDnsSoaRecordResource(ResourceIdentifier id)
        {
            DnsSoaRecordResource.ValidateResourceId(id);
            return new DnsSoaRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsSrvRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsSrvRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsSrvRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsSrvRecordResource"/> object. </returns>
        public virtual DnsSrvRecordResource GetDnsSrvRecordResource(ResourceIdentifier id)
        {
            DnsSrvRecordResource.ValidateResourceId(id);
            return new DnsSrvRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsTxtRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsTxtRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsTxtRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsTxtRecordResource"/> object. </returns>
        public virtual DnsTxtRecordResource GetDnsTxtRecordResource(ResourceIdentifier id)
        {
            DnsTxtRecordResource.ValidateResourceId(id);
            return new DnsTxtRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsTlsaRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsTlsaRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsTlsaRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsTlsaRecordResource"/> object. </returns>
        public virtual DnsTlsaRecordResource GetDnsTlsaRecordResource(ResourceIdentifier id)
        {
            DnsTlsaRecordResource.ValidateResourceId(id);
            return new DnsTlsaRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsDSRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsDSRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsDSRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsDSRecordResource"/> object. </returns>
        public virtual DnsDSRecordResource GetDnsDSRecordResource(ResourceIdentifier id)
        {
            DnsDSRecordResource.ValidateResourceId(id);
            return new DnsDSRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsNaptrRecordResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsNaptrRecordResource.CreateResourceIdentifier(string,string,string,string)" /> to create a <see cref="DnsNaptrRecordResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsNaptrRecordResource"/> object. </returns>
        public virtual DnsNaptrRecordResource GetDnsNaptrRecordResource(ResourceIdentifier id)
        {
            DnsNaptrRecordResource.ValidateResourceId(id);
            return new DnsNaptrRecordResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DnsZoneResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DnsZoneResource.CreateResourceIdentifier(string,string,string)" /> to create a <see cref="DnsZoneResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DnsZoneResource"/> object. </returns>
        public virtual DnsZoneResource GetDnsZoneResource(ResourceIdentifier id)
        {
            DnsZoneResource.ValidateResourceId(id);
            return new DnsZoneResource(Client, id);
        }
    }
}
