// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Dns.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Dns
{
    /// <summary>
    /// A class representing the DnssecConfig data model.
    /// Represents the DNSSEC configuration.
    /// </summary>
    public partial class DnssecConfigData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DnssecConfigData"/>. </summary>
        internal DnssecConfigData()
        {
            SigningKeys = new ChangeTrackingList<DnsSigningKey>();
        }

        /// <summary> Initializes a new instance of <see cref="DnssecConfigData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> The etag of the DNSSEC configuration. </param>
        /// <param name="provisioningState"> Provisioning State of the DNSSEC configuration. </param>
        /// <param name="signingKeys"> The list of signing keys. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DnssecConfigData(ResourceIdentifier id, string name, ResourceType resourceType, ResourceManager.Models.SystemData systemData, ETag? etag, string provisioningState, IReadOnlyList<DnsSigningKey> signingKeys, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ETag = etag;
            ProvisioningState = provisioningState;
            SigningKeys = signingKeys;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The etag of the DNSSEC configuration. </summary>
        public ETag? ETag { get; }
        /// <summary> Provisioning State of the DNSSEC configuration. </summary>
        public string ProvisioningState { get; }
        /// <summary> The list of signing keys. </summary>
        public IReadOnlyList<DnsSigningKey> SigningKeys { get; }
    }
}
