// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DigitalTwins.Models
{
    /// <summary> Specifies whether or not to record twin / relationship property and item removals, including removals of indexed or keyed values (such as map entries, array elements, etc.). This feature is de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the property events table in ADX. </summary>
    public readonly partial struct RecordPropertyAndItemRemoval : IEquatable<RecordPropertyAndItemRemoval>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecordPropertyAndItemRemoval"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecordPropertyAndItemRemoval(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "true";
        private const string FalseValue = "false";

        /// <summary> true. </summary>
        public static RecordPropertyAndItemRemoval True { get; } = new RecordPropertyAndItemRemoval(TrueValue);
        /// <summary> false. </summary>
        public static RecordPropertyAndItemRemoval False { get; } = new RecordPropertyAndItemRemoval(FalseValue);
        /// <summary> Determines if two <see cref="RecordPropertyAndItemRemoval"/> values are the same. </summary>
        public static bool operator ==(RecordPropertyAndItemRemoval left, RecordPropertyAndItemRemoval right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecordPropertyAndItemRemoval"/> values are not the same. </summary>
        public static bool operator !=(RecordPropertyAndItemRemoval left, RecordPropertyAndItemRemoval right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecordPropertyAndItemRemoval"/>. </summary>
        public static implicit operator RecordPropertyAndItemRemoval(string value) => new RecordPropertyAndItemRemoval(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecordPropertyAndItemRemoval other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecordPropertyAndItemRemoval other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
