// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DigitalTwins.Models
{
    /// <summary> The type of resource, for instance Microsoft.DigitalTwins/digitalTwinsInstances. </summary>
    public readonly partial struct DigitalTwinsResourceType : IEquatable<DigitalTwinsResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DigitalTwinsResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DigitalTwinsResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftDigitalTwinsDigitalTwinsInstancesValue = "Microsoft.DigitalTwins/digitalTwinsInstances";

        /// <summary> Microsoft.DigitalTwins/digitalTwinsInstances. </summary>
        public static DigitalTwinsResourceType MicrosoftDigitalTwinsDigitalTwinsInstances { get; } = new DigitalTwinsResourceType(MicrosoftDigitalTwinsDigitalTwinsInstancesValue);
        /// <summary> Determines if two <see cref="DigitalTwinsResourceType"/> values are the same. </summary>
        public static bool operator ==(DigitalTwinsResourceType left, DigitalTwinsResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DigitalTwinsResourceType"/> values are not the same. </summary>
        public static bool operator !=(DigitalTwinsResourceType left, DigitalTwinsResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DigitalTwinsResourceType"/>. </summary>
        public static implicit operator DigitalTwinsResourceType(string value) => new DigitalTwinsResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DigitalTwinsResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DigitalTwinsResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
