// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DigitalTwins.Models
{
    /// <summary> Public network access for the DigitalTwinsInstance. </summary>
    public readonly partial struct DigitalTwinsPublicNetworkAccess : IEquatable<DigitalTwinsPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DigitalTwinsPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DigitalTwinsPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DigitalTwinsPublicNetworkAccess Enabled { get; } = new DigitalTwinsPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DigitalTwinsPublicNetworkAccess Disabled { get; } = new DigitalTwinsPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="DigitalTwinsPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(DigitalTwinsPublicNetworkAccess left, DigitalTwinsPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DigitalTwinsPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(DigitalTwinsPublicNetworkAccess left, DigitalTwinsPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DigitalTwinsPublicNetworkAccess"/>. </summary>
        public static implicit operator DigitalTwinsPublicNetworkAccess(string value) => new DigitalTwinsPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DigitalTwinsPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DigitalTwinsPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
