// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DigitalTwins.Models
{
    /// <summary> The provisioning state. </summary>
    public readonly partial struct DigitalTwinsProvisioningState : IEquatable<DigitalTwinsProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DigitalTwinsProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DigitalTwinsProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProvisioningValue = "Provisioning";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeletedValue = "Deleted";
        private const string WarningValue = "Warning";
        private const string SuspendingValue = "Suspending";
        private const string RestoringValue = "Restoring";
        private const string MovingValue = "Moving";

        /// <summary> Provisioning. </summary>
        public static DigitalTwinsProvisioningState Provisioning { get; } = new DigitalTwinsProvisioningState(ProvisioningValue);
        /// <summary> Deleting. </summary>
        public static DigitalTwinsProvisioningState Deleting { get; } = new DigitalTwinsProvisioningState(DeletingValue);
        /// <summary> Updating. </summary>
        public static DigitalTwinsProvisioningState Updating { get; } = new DigitalTwinsProvisioningState(UpdatingValue);
        /// <summary> Succeeded. </summary>
        public static DigitalTwinsProvisioningState Succeeded { get; } = new DigitalTwinsProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static DigitalTwinsProvisioningState Failed { get; } = new DigitalTwinsProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static DigitalTwinsProvisioningState Canceled { get; } = new DigitalTwinsProvisioningState(CanceledValue);
        /// <summary> Deleted. </summary>
        public static DigitalTwinsProvisioningState Deleted { get; } = new DigitalTwinsProvisioningState(DeletedValue);
        /// <summary> Warning. </summary>
        public static DigitalTwinsProvisioningState Warning { get; } = new DigitalTwinsProvisioningState(WarningValue);
        /// <summary> Suspending. </summary>
        public static DigitalTwinsProvisioningState Suspending { get; } = new DigitalTwinsProvisioningState(SuspendingValue);
        /// <summary> Restoring. </summary>
        public static DigitalTwinsProvisioningState Restoring { get; } = new DigitalTwinsProvisioningState(RestoringValue);
        /// <summary> Moving. </summary>
        public static DigitalTwinsProvisioningState Moving { get; } = new DigitalTwinsProvisioningState(MovingValue);
        /// <summary> Determines if two <see cref="DigitalTwinsProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DigitalTwinsProvisioningState left, DigitalTwinsProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DigitalTwinsProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DigitalTwinsProvisioningState left, DigitalTwinsProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DigitalTwinsProvisioningState"/>. </summary>
        public static implicit operator DigitalTwinsProvisioningState(string value) => new DigitalTwinsProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DigitalTwinsProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DigitalTwinsProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
