// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DigitalTwins.Models
{
    /// <summary> The provisioning state. </summary>
    public readonly partial struct DigitalTwinsPrivateLinkResourceProvisioningState : IEquatable<DigitalTwinsPrivateLinkResourceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DigitalTwinsPrivateLinkResourceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DigitalTwinsPrivateLinkResourceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";
        private const string DisconnectedValue = "Disconnected";

        /// <summary> Pending. </summary>
        public static DigitalTwinsPrivateLinkResourceProvisioningState Pending { get; } = new DigitalTwinsPrivateLinkResourceProvisioningState(PendingValue);
        /// <summary> Approved. </summary>
        public static DigitalTwinsPrivateLinkResourceProvisioningState Approved { get; } = new DigitalTwinsPrivateLinkResourceProvisioningState(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static DigitalTwinsPrivateLinkResourceProvisioningState Rejected { get; } = new DigitalTwinsPrivateLinkResourceProvisioningState(RejectedValue);
        /// <summary> Disconnected. </summary>
        public static DigitalTwinsPrivateLinkResourceProvisioningState Disconnected { get; } = new DigitalTwinsPrivateLinkResourceProvisioningState(DisconnectedValue);
        /// <summary> Determines if two <see cref="DigitalTwinsPrivateLinkResourceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DigitalTwinsPrivateLinkResourceProvisioningState left, DigitalTwinsPrivateLinkResourceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DigitalTwinsPrivateLinkResourceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DigitalTwinsPrivateLinkResourceProvisioningState left, DigitalTwinsPrivateLinkResourceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DigitalTwinsPrivateLinkResourceProvisioningState"/>. </summary>
        public static implicit operator DigitalTwinsPrivateLinkResourceProvisioningState(string value) => new DigitalTwinsPrivateLinkResourceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DigitalTwinsPrivateLinkResourceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DigitalTwinsPrivateLinkResourceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
