// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DigitalTwins.Models
{
    /// <summary> Message providing the reason why the given name is invalid. </summary>
    public readonly partial struct DigitalTwinsNameUnavailableReason : IEquatable<DigitalTwinsNameUnavailableReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DigitalTwinsNameUnavailableReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DigitalTwinsNameUnavailableReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AlreadyExistsValue = "AlreadyExists";

        /// <summary> Invalid. </summary>
        public static DigitalTwinsNameUnavailableReason Invalid { get; } = new DigitalTwinsNameUnavailableReason(InvalidValue);
        /// <summary> AlreadyExists. </summary>
        public static DigitalTwinsNameUnavailableReason AlreadyExists { get; } = new DigitalTwinsNameUnavailableReason(AlreadyExistsValue);
        /// <summary> Determines if two <see cref="DigitalTwinsNameUnavailableReason"/> values are the same. </summary>
        public static bool operator ==(DigitalTwinsNameUnavailableReason left, DigitalTwinsNameUnavailableReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DigitalTwinsNameUnavailableReason"/> values are not the same. </summary>
        public static bool operator !=(DigitalTwinsNameUnavailableReason left, DigitalTwinsNameUnavailableReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DigitalTwinsNameUnavailableReason"/>. </summary>
        public static implicit operator DigitalTwinsNameUnavailableReason(string value) => new DigitalTwinsNameUnavailableReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DigitalTwinsNameUnavailableReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DigitalTwinsNameUnavailableReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
