// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DigitalTwins.Models
{
    /// <summary> Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified. </summary>
    public readonly partial struct DigitalTwinsAuthenticationType : IEquatable<DigitalTwinsAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DigitalTwinsAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DigitalTwinsAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string KeyBasedValue = "KeyBased";
        private const string IdentityBasedValue = "IdentityBased";

        /// <summary> KeyBased. </summary>
        public static DigitalTwinsAuthenticationType KeyBased { get; } = new DigitalTwinsAuthenticationType(KeyBasedValue);
        /// <summary> IdentityBased. </summary>
        public static DigitalTwinsAuthenticationType IdentityBased { get; } = new DigitalTwinsAuthenticationType(IdentityBasedValue);
        /// <summary> Determines if two <see cref="DigitalTwinsAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(DigitalTwinsAuthenticationType left, DigitalTwinsAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DigitalTwinsAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(DigitalTwinsAuthenticationType left, DigitalTwinsAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DigitalTwinsAuthenticationType"/>. </summary>
        public static implicit operator DigitalTwinsAuthenticationType(string value) => new DigitalTwinsAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DigitalTwinsAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DigitalTwinsAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
