// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DigitalTwins.Models
{
    /// <summary> The type of time series connection resource. </summary>
    internal readonly partial struct ConnectionType : IEquatable<ConnectionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureDataExplorerValue = "AzureDataExplorer";

        /// <summary> AzureDataExplorer. </summary>
        public static ConnectionType AzureDataExplorer { get; } = new ConnectionType(AzureDataExplorerValue);
        /// <summary> Determines if two <see cref="ConnectionType"/> values are the same. </summary>
        public static bool operator ==(ConnectionType left, ConnectionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectionType"/> values are not the same. </summary>
        public static bool operator !=(ConnectionType left, ConnectionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectionType"/>. </summary>
        public static implicit operator ConnectionType(string value) => new ConnectionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
